/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.calculator;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.spi.fees.ServiceFeeCalculator;
import com.hedera.node.app.spi.fees.SimpleFeeContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.config.data.TokensConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.hiero.hapi.fees.FeeResult;
import org.hiero.hapi.fees.FeeScheduleUtils;
import org.hiero.hapi.support.fees.FeeSchedule;
import org.hiero.hapi.support.fees.ServiceFeeDefinition;

public class TokenClaimAirdropFeeCalculator
implements ServiceFeeCalculator {
    public void accumulateServiceFee(@NonNull TransactionBody txnBody, @NonNull SimpleFeeContext simpleFeeContext, @NonNull FeeResult feeResult, @NonNull FeeSchedule feeSchedule) {
        if (simpleFeeContext.feeContext() != null) {
            TokensConfig tokenConfig = (TokensConfig)simpleFeeContext.feeContext().configuration().getConfigData(TokensConfig.class);
            HandleException.validateTrue((boolean)tokenConfig.airdropsClaimEnabled(), (ResponseCodeEnum)ResponseCodeEnum.NOT_SUPPORTED);
        }
        ServiceFeeDefinition serviceDef = FeeScheduleUtils.lookupServiceFee((FeeSchedule)feeSchedule, (HederaFunctionality)HederaFunctionality.TOKEN_CLAIM_AIRDROP);
        feeResult.setServiceBaseFeeTinycents(serviceDef.baseFee());
    }

    public TransactionBody.DataOneOfType getTransactionType() {
        return TransactionBody.DataOneOfType.TOKEN_CLAIM_AIRDROP;
    }
}

