/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.pcli.graph;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.platform.event.EventCore;
import com.hedera.hapi.platform.event.EventDescriptor;
import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.common.context.PlatformContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.hiero.base.crypto.Hash;
import org.hiero.base.crypto.Signature;
import org.hiero.consensus.crypto.PbjStreamHasher;
import org.hiero.consensus.crypto.PlatformSigner;
import org.hiero.consensus.hashgraph.config.ConsensusConfig;
import org.hiero.consensus.model.event.EventDescriptorWrapper;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.event.UnsignedEvent;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.node.KeysAndCerts;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.transaction.TransactionWrapper;
import org.hiero.consensus.pces.impl.common.CommonPcesWriter;
import org.hiero.consensus.pces.impl.common.PcesFileManager;
import org.hiero.consensus.pces.impl.common.PcesFileTracker;
import org.hiero.consensus.pcli.PcesSliceCommand;
import org.hiero.consensus.pcli.graph.EventGraphPipeline;
import org.hiero.consensus.pcli.graph.OrphanBufferEventGraphSource;
import org.hiero.consensus.pcli.graph.PcesEventGraphSource;
import org.hiero.consensus.round.EventWindowUtils;

public class PcesGraphSlicer {
    private final Path pcesOutputLocation;
    private final Map<Bytes, EventDescriptor> migratedParents;
    private final PbjStreamHasher eventHasher;
    private final Map<NodeId, PlatformSigner> signers;
    private final PlatformContext context;
    private final Function<EventCore, EventCore> eventCoreModifier;
    private final EventGraphPipeline graphPipeline;
    private CommonPcesWriter pcesWriter;

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    private PcesGraphSlicer(@NonNull Builder builder) {
        Objects.requireNonNull(builder.keysAndCertsMap, "keysAndCertsMap is required");
        Objects.requireNonNull(builder.graphEventCoreModifier, "graphEventOverwriter is required");
        Objects.requireNonNull(builder.graphEventFilter, "graphEventFilter is required");
        Objects.requireNonNull(builder.existingPcesFilesLocation, "existingPcesFilesLocation is required");
        Objects.requireNonNull(builder.exportPcesFileLocation, "exportPcesFileLocation is required");
        this.pcesOutputLocation = builder.exportPcesFileLocation;
        this.migratedParents = new HashMap<Bytes, EventDescriptor>();
        this.eventHasher = new PbjStreamHasher();
        this.signers = PcesSliceCommand.generateSigners(builder.keysAndCertsMap, PlatformSigner::new);
        this.context = builder.context != null ? builder.context : PcesSliceCommand.createDefaultPlatformContext();
        this.eventCoreModifier = builder.graphEventCoreModifier;
        PcesEventGraphSource rawSource = new PcesEventGraphSource(builder.existingPcesFilesLocation, this.context);
        OrphanBufferEventGraphSource orphanBufferSource = new OrphanBufferEventGraphSource(rawSource, this.context);
        if (builder.consensusSnapshot != null) {
            int roundsNonAncient = ((ConsensusConfig)this.context.getConfiguration().getConfigData(ConsensusConfig.class)).roundsNonAncient();
            EventWindow eventWindow = EventWindowUtils.createEventWindow((ConsensusSnapshot)builder.consensusSnapshot, (int)roundsNonAncient);
            orphanBufferSource.setEventWindow(eventWindow);
        }
        this.graphPipeline = new EventGraphPipeline(orphanBufferSource, builder.graphEventFilter::test, this::process, this::writeEventToPces, null);
    }

    @NonNull
    private PlatformEvent process(@NonNull PlatformEvent event) {
        EventCore newEventCore = this.eventCoreModifier.apply(event.getEventCore());
        List<EventDescriptor> parents = event.getAllParents().stream().map(parent -> this.migratedParents.get(parent.hash().getBytes())).filter(Objects::nonNull).toList();
        List<Bytes> transactions = event.getTransactions().stream().map(TransactionWrapper::getApplicationTransaction).toList();
        UnsignedEvent unsignedEvent = new UnsignedEvent(NodeId.of((long)newEventCore.creatorNodeId()), parents.stream().map(EventDescriptorWrapper::new).toList(), newEventCore.birthRound(), HapiUtils.asInstant((Timestamp)newEventCore.timeCreated()), transactions, newEventCore.coin());
        this.eventHasher.hashUnsignedEvent(unsignedEvent);
        Hash newHash = unsignedEvent.getHash();
        PlatformSigner signer = this.signers.get(event.getCreatorId());
        if (signer == null) {
            throw new IllegalStateException("No signer found for node " + String.valueOf(event.getCreatorId()) + ". Ensure keysAndCertsMap contains all nodes.");
        }
        Signature signature = signer.sign(newHash.getBytes().toByteArray());
        EventDescriptor eventDescriptor = new EventDescriptor.Builder().hash(newHash.getBytes()).creatorNodeId(newEventCore.creatorNodeId()).birthRound(newEventCore.birthRound()).build();
        this.migratedParents.put(event.getHash().getBytes(), eventDescriptor);
        return new PlatformEvent(unsignedEvent, signature.getBytes());
    }

    private void initializePcesWriter() {
        try {
            Files.createDirectories(this.pcesOutputLocation, new FileAttribute[0]);
            this.pcesWriter = new CommonPcesWriter(this.context.getConfiguration(), new PcesFileManager(this.context.getConfiguration(), this.context.getMetrics(), this.context.getTime(), new PcesFileTracker(), this.pcesOutputLocation, 0L));
            this.pcesWriter.beginStreamingNewEvents();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to initialize PCES writer", e);
        }
    }

    private void writeEventToPces(@NonNull PlatformEvent event) {
        try {
            this.pcesWriter.prepareOutputStream(event);
            this.pcesWriter.getCurrentMutableFile().writeEvent(event);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write event to PCES", e);
        }
    }

    private void closePcesWriter() {
        if (this.pcesWriter != null) {
            this.pcesWriter.closeCurrentMutableFile();
        }
    }

    public void slice() {
        this.initializePcesWriter();
        try {
            this.graphPipeline.process();
        }
        finally {
            this.closePcesWriter();
        }
    }

    public static class Builder {
        private PlatformContext context;
        private Map<NodeId, KeysAndCerts> keysAndCertsMap;
        private Function<EventCore, EventCore> graphEventCoreModifier;
        private Predicate<PlatformEvent> graphEventFilter;
        private Path existingPcesFilesLocation;
        private Path exportPcesFileLocation;
        private ConsensusSnapshot consensusSnapshot;

        private Builder() {
        }

        @NonNull
        public Builder context(@NonNull PlatformContext context) {
            this.context = Objects.requireNonNull(context);
            return this;
        }

        @NonNull
        public Builder keysAndCertsMap(@NonNull Map<NodeId, KeysAndCerts> keysAndCertsMap) {
            this.keysAndCertsMap = Objects.requireNonNull(keysAndCertsMap);
            return this;
        }

        @NonNull
        public Builder graphEventCoreModifier(@NonNull Function<EventCore, EventCore> graphEventOverwriter) {
            this.graphEventCoreModifier = Objects.requireNonNull(graphEventOverwriter);
            return this;
        }

        @NonNull
        public Builder graphEventFilter(@NonNull EventGraphPipeline.EventFilter graphEventFilter) {
            this.graphEventFilter = Objects.requireNonNull(graphEventFilter);
            return this;
        }

        @NonNull
        public Builder existingPcesFilesLocation(@NonNull Path existingPcesFilesLocation) {
            this.existingPcesFilesLocation = Objects.requireNonNull(existingPcesFilesLocation);
            return this;
        }

        @NonNull
        public Builder exportPcesFileLocation(@NonNull Path exportPcesFileLocation) {
            this.exportPcesFileLocation = Objects.requireNonNull(exportPcesFileLocation);
            return this;
        }

        @NonNull
        public Builder consensusSnapshot(@NonNull ConsensusSnapshot consensusSnapshot) {
            this.consensusSnapshot = consensusSnapshot;
            return this;
        }

        @NonNull
        public PcesGraphSlicer build() {
            return new PcesGraphSlicer(this);
        }
    }
}

