/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.metrics.platform;

import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class MetricsEventBus<T> {
    private final Executor executor;
    private final Queue<Consumer<? super T>> subscribers = new ConcurrentLinkedQueue<Consumer<? super T>>();

    public MetricsEventBus(Executor executor) {
        this.executor = Objects.requireNonNull(executor, "executor must not be null");
    }

    public Runnable subscribe(Consumer<? super T> subscriber, Supplier<Stream<T>> previousEvents) {
        Objects.requireNonNull(subscriber, "subscriber must not be null");
        Objects.requireNonNull(previousEvents, "previousEvents must not be null");
        this.subscribers.add(subscriber);
        this.executor.execute(() -> ((Stream)previousEvents.get()).forEach(subscriber));
        return () -> this.subscribers.remove(subscriber);
    }

    public void submit(T event) {
        Objects.requireNonNull(event, "event must not be null");
        this.executor.execute(() -> this.subscribers.forEach(subscriber -> subscriber.accept(event)));
    }
}

