/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.reconnect;

import com.swirlds.common.merkle.synchronization.task.ReconnectNodeCount;
import com.swirlds.virtualmap.internal.Path;
import com.swirlds.virtualmap.internal.reconnect.NodeTraversalOrder;
import java.util.Deque;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class TwoPhasePessimisticTraversalOrder
implements NodeTraversalOrder {
    private ReconnectNodeCount nodeCount;
    private long reconnectFirstLeafPath;
    private long reconnectLastLeafPath;
    private final Set<Long> cleanNodes = ConcurrentHashMap.newKeySet();
    private int chunkCount;
    private int chunksStopRank;
    private AtomicReferenceArray<Integer> chunkStartRanks;
    private AtomicReferenceArray<Long> chunkStartPaths;
    private AtomicReferenceArray<Long> chunkWidths;
    private int lastSentPathChunk;
    private AtomicReferenceArray<Deque<Long>> chunkNextToCheckPaths;
    private Map<Integer, Long> chunkNextPessimisticPaths;
    private long lastLeafPath = -1L;

    @Override
    public void start(long firstLeafPath, long lastLeafPath, ReconnectNodeCount nodeCount) {
        this.reconnectFirstLeafPath = firstLeafPath;
        this.reconnectLastLeafPath = lastLeafPath;
        this.nodeCount = nodeCount;
        int leafParentRank = Path.getRank(firstLeafPath) - 1;
        if (leafParentRank < 5) {
            this.chunkCount = 0;
            return;
        }
        this.chunksStopRank = leafParentRank / 2;
        this.chunkCount = 1 << this.chunksStopRank;
        int minChunkHeight = leafParentRank - this.chunksStopRank;
        long firstPathInLeafParentRank = Path.getLeftGrandChildPath(0L, leafParentRank);
        this.chunkStartPaths = new AtomicReferenceArray(this.chunkCount);
        this.chunkWidths = new AtomicReferenceArray(this.chunkCount);
        this.chunkStartRanks = new AtomicReferenceArray(this.chunkCount);
        this.chunkNextToCheckPaths = new AtomicReferenceArray(this.chunkCount);
        this.chunkNextPessimisticPaths = new ConcurrentHashMap<Integer, Long>(this.chunkCount);
        for (int i = 0; i < this.chunkCount; ++i) {
            long chunkWidth;
            long startPath;
            int startRank;
            long p = firstPathInLeafParentRank + ((long)i << minChunkHeight);
            if (Path.getLeftChildPath(p) + (2L << minChunkHeight) <= this.reconnectFirstLeafPath) {
                startRank = leafParentRank + 1;
                startPath = Path.getLeftChildPath(p);
                chunkWidth = 2L << minChunkHeight;
            } else {
                startRank = leafParentRank;
                startPath = p;
                chunkWidth = 1L << minChunkHeight;
            }
            this.chunkStartPaths.set(i, startPath);
            this.chunkStartRanks.set(i, startRank);
            this.chunkWidths.set(i, chunkWidth);
            this.chunkNextToCheckPaths.set(i, new ConcurrentLinkedDeque());
            this.chunkNextPessimisticPaths.put(i, this.chunkStartPaths.get(i));
        }
        this.lastSentPathChunk = -1;
    }

    @Override
    public void nodeReceived(long path, boolean isClean) {
        boolean isLeaf;
        boolean bl = isLeaf = path >= this.reconnectFirstLeafPath;
        if (isLeaf) {
            this.nodeCount.incrementLeafCount();
            if (isClean) {
                this.nodeCount.incrementRedundantLeafCount();
            }
        } else {
            if (path != 0L) {
                assert (this.chunkCount > 0);
                int chunk = this.getPathChunk(path);
                if (isClean) {
                    this.cleanNodes.add(path);
                    this.cleanNodes.remove(Path.getLeftChildPath(path));
                    this.cleanNodes.remove(Path.getRightChildPath(path));
                    if (path != 1L && Path.isLeft(path)) {
                        this.chunkNextToCheckPaths.get(chunk).addFirst(Path.getParentPath(path));
                    }
                } else {
                    int chunkStartRank = this.chunkStartRanks.get(chunk);
                    int pathRank = Path.getRank(path);
                    if (pathRank == chunkStartRank && Path.isLeft(path)) {
                        this.chunkNextToCheckPaths.get(chunk).addLast(path + 1L);
                    }
                }
            }
            this.nodeCount.incrementInternalCount();
            if (isClean) {
                this.nodeCount.incrementRedundantInternalCount();
            }
        }
    }

    @Override
    public long getNextPathToSend() {
        long result = -1L;
        if (this.lastLeafPath == -1L) {
            for (int i = 0; i < this.chunkCount; ++i) {
                int chunk = (this.lastSentPathChunk + 1 + i) % this.chunkCount;
                Deque<Long> toCheck = this.chunkNextToCheckPaths.get(chunk);
                long l = result = toCheck.isEmpty() ? -1L : toCheck.pollFirst();
                while (result != -1L && this.hasCleanParent(result)) {
                    result = toCheck.isEmpty() ? -1L : toCheck.pollFirst();
                }
                if (result != -1L) {
                    this.lastSentPathChunk = chunk;
                    break;
                }
                long nextPessimisticPath = this.chunkNextPessimisticPaths.get(chunk);
                if (nextPessimisticPath == -1L) continue;
                result = this.skipCleanPaths(nextPessimisticPath, this.getLastChunkPath(chunk));
                if (result == -1L) {
                    this.chunkNextPessimisticPaths.put(chunk, -1L);
                    continue;
                }
                assert (Path.isLeft(result));
                this.lastSentPathChunk = chunk;
                long next = result + 2L;
                if (next > this.getLastChunkPath(chunk)) {
                    next = -1L;
                }
                this.chunkNextPessimisticPaths.put(chunk, next);
                break;
            }
        }
        if (result == -1L) {
            result = this.getNextLeafPath();
        }
        return result;
    }

    private long getNextLeafPath() {
        long path;
        long l = path = this.lastLeafPath == -1L ? this.reconnectFirstLeafPath : this.lastLeafPath + 1L;
        if (path > this.reconnectLastLeafPath || this.reconnectFirstLeafPath < 0L) {
            return -1L;
        }
        long result = this.skipCleanPaths(path, this.reconnectLastLeafPath);
        assert (result == -1L || result >= this.reconnectFirstLeafPath);
        this.lastLeafPath = result;
        return this.lastLeafPath;
    }

    private int getPathChunk(long path) {
        int rank = Path.getRank(path);
        if (rank < this.chunksStopRank) {
            path = Path.getLeftGrandChildPath(path, this.chunksStopRank - rank);
            rank = this.chunksStopRank;
        }
        long pathAtTopRank = Path.getGrandParentPath(path, rank - this.chunksStopRank);
        return (int)(pathAtTopRank - Path.getLeftGrandChildPath(0L, this.chunksStopRank));
    }

    private long getLastChunkPath(int chunk) {
        return this.chunkStartPaths.get(chunk) + this.chunkWidths.get(chunk) - 1L;
    }

    private boolean hasCleanParent(long path) {
        long parent = Path.getParentPath(path);
        boolean clean = false;
        while (parent > 0L && !clean) {
            clean = this.cleanNodes.contains(parent);
            parent = Path.getParentPath(parent);
        }
        return clean;
    }

    private long skipCleanPaths(long path, long limit) {
        long result = this.skipCleanPaths(path);
        while (result < limit && result != path) {
            path = result;
            result = this.skipCleanPaths(path);
        }
        return result <= limit ? result : -1L;
    }

    private long skipCleanPaths(long path) {
        assert (path > 0L);
        long parent = Path.getParentPath(path);
        long cleanParent = -1L;
        int parentRanksAbove = 1;
        int cleanParentRanksAbove = 1;
        while (parent != 0L) {
            if (this.cleanNodes.contains(parent)) {
                cleanParent = parent;
                cleanParentRanksAbove = parentRanksAbove;
            }
            ++parentRanksAbove;
            parent = Path.getParentPath(parent);
        }
        long result = cleanParent == -1L ? path : Path.getRightGrandChildPath(cleanParent, cleanParentRanksAbove) + 1L;
        assert (result >= path);
        return result;
    }
}

