/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.blocks;

import com.hedera.hapi.block.stream.output.CreateScheduleOutput;
import com.hedera.hapi.block.stream.output.EthereumOutput;
import com.hedera.hapi.block.stream.output.SignScheduleOutput;
import com.hedera.hapi.block.stream.output.TransactionOutput;
import com.hedera.hapi.block.stream.output.TransactionResult;
import com.hedera.hapi.block.stream.output.UtilPrngOutput;
import com.hedera.hapi.block.stream.trace.EvmTransactionLog;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.contract.ContractFunctionResult;
import com.hedera.hapi.node.contract.ContractLoginfo;
import com.hedera.hapi.node.contract.ContractNonceInfo;
import com.hedera.hapi.node.contract.EvmTransactionResult;
import com.hedera.hapi.node.contract.InternalCallContext;
import com.hedera.hapi.node.transaction.TransactionReceipt;
import com.hedera.hapi.node.transaction.TransactionRecord;
import com.hedera.node.app.blocks.impl.TranslationContext;
import com.hedera.node.app.blocks.impl.contexts.AirdropOpContext;
import com.hedera.node.app.blocks.impl.contexts.ContractOpContext;
import com.hedera.node.app.blocks.impl.contexts.CryptoOpContext;
import com.hedera.node.app.blocks.impl.contexts.FileOpContext;
import com.hedera.node.app.blocks.impl.contexts.MintOpContext;
import com.hedera.node.app.blocks.impl.contexts.NodeOpContext;
import com.hedera.node.app.blocks.impl.contexts.ScheduleOpContext;
import com.hedera.node.app.blocks.impl.contexts.SubmitOpContext;
import com.hedera.node.app.blocks.impl.contexts.SupplyChangeOpContext;
import com.hedera.node.app.blocks.impl.contexts.TokenOpContext;
import com.hedera.node.app.blocks.impl.contexts.TopicOpContext;
import com.hedera.node.app.hapi.utils.contracts.HookUtils;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.service.token.api.ContractChangeSummary;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.hyperledger.besu.evm.log.Log;

public class BlockItemsTranslator {
    private static final Function<TransactionOutput, EvmTransactionResult> CONTRACT_CALL_EXTRACTOR = output -> output.contractCallOrThrow().evmTransactionResultOrThrow();
    private static final Function<TransactionOutput, EvmTransactionResult> CONTRACT_CREATE_EXTRACTOR = output -> output.contractCreateOrThrow().evmTransactionResultOrThrow();
    public static final BlockItemsTranslator BLOCK_ITEMS_TRANSLATOR = new BlockItemsTranslator();

    public TransactionReceipt translateReceipt(@NonNull TranslationContext context, @NonNull TransactionResult result, TransactionOutput ... outputs) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(result);
        Objects.requireNonNull(outputs);
        TransactionReceipt.Builder receiptBuilder = TransactionReceipt.newBuilder().status(result.status()).exchangeRate(context.transactionExchangeRates());
        HederaFunctionality function = context.functionality();
        switch (function) {
            case CONTRACT_CALL: 
            case CONTRACT_CREATE: 
            case CONTRACT_DELETE: 
            case CONTRACT_UPDATE: 
            case ETHEREUM_TRANSACTION: {
                receiptBuilder.contractID(((ContractOpContext)context).contractId());
                break;
            }
            case CRYPTO_CREATE: 
            case CRYPTO_UPDATE: {
                receiptBuilder.accountID(((CryptoOpContext)context).accountId());
                break;
            }
            case FILE_CREATE: {
                receiptBuilder.fileID(((FileOpContext)context).fileId());
                break;
            }
            case NODE_CREATE: {
                receiptBuilder.nodeId(((NodeOpContext)context).nodeId());
                break;
            }
            case SCHEDULE_CREATE: {
                CreateScheduleOutput scheduleOutput = BlockItemsTranslator.outputValueIfPresent(TransactionOutput::hasCreateSchedule, TransactionOutput::createScheduleOrThrow, outputs);
                if (scheduleOutput == null) break;
                receiptBuilder.scheduleID(scheduleOutput.scheduleId()).scheduledTransactionID(scheduleOutput.scheduledTransactionId());
                break;
            }
            case SCHEDULE_DELETE: {
                receiptBuilder.scheduleID(((ScheduleOpContext)context).scheduleId());
                break;
            }
            case SCHEDULE_SIGN: {
                SignScheduleOutput signOutput = BlockItemsTranslator.outputValueIfPresent(TransactionOutput::hasSignSchedule, TransactionOutput::signScheduleOrThrow, outputs);
                if (signOutput == null) break;
                receiptBuilder.scheduledTransactionID(signOutput.scheduledTransactionId());
                break;
            }
            case CONSENSUS_SUBMIT_MESSAGE: {
                receiptBuilder.topicRunningHashVersion(((SubmitOpContext)context).runningHashVersion()).topicSequenceNumber(((SubmitOpContext)context).sequenceNumber()).topicRunningHash(((SubmitOpContext)context).runningHash());
                break;
            }
            case TOKEN_MINT: {
                receiptBuilder.newTotalSupply(((MintOpContext)context).newTotalSupply()).serialNumbers(((MintOpContext)context).serialNumbers());
                break;
            }
            case TOKEN_BURN: 
            case TOKEN_ACCOUNT_WIPE: {
                receiptBuilder.newTotalSupply(((SupplyChangeOpContext)context).newTotalSupply());
                break;
            }
            case TOKEN_CREATE: {
                receiptBuilder.tokenID(((TokenOpContext)context).tokenId());
                break;
            }
            case CONSENSUS_CREATE_TOPIC: {
                receiptBuilder.topicID(((TopicOpContext)context).topicId());
            }
        }
        return receiptBuilder.build();
    }

    public TransactionRecord translateRecord(@NonNull TranslationContext context, @NonNull TransactionResult result, @Nullable List<EvmTransactionLog> logs, TransactionOutput ... outputs) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(result);
        Objects.requireNonNull(outputs);
        TransactionRecord.Builder recordBuilder = TransactionRecord.newBuilder().transactionID(context.txnId()).memo(context.memo()).transactionHash(context.transactionHash()).consensusTimestamp(result.consensusTimestamp()).parentConsensusTimestamp(result.parentConsensusTimestamp()).scheduleRef(result.scheduleRef()).transactionFee(result.transactionFeeCharged()).transferList(result.transferList()).tokenTransferLists(result.tokenTransferLists()).automaticTokenAssociations(result.automaticTokenAssociations()).assessedCustomFees(result.assessedCustomFees()).paidStakingRewards(result.paidStakingRewards());
        HederaFunctionality function = context.functionality();
        block0 : switch (function) {
            case CONTRACT_CALL: 
            case CONTRACT_CREATE: 
            case CONTRACT_DELETE: 
            case CONTRACT_UPDATE: 
            case ETHEREUM_TRANSACTION: 
            case HOOK_DISPATCH: {
                if (function == HederaFunctionality.CONTRACT_CALL || function == HederaFunctionality.HOOK_DISPATCH) {
                    recordBuilder.contractCallResult(BlockItemsTranslator.outputValueIfPresent(TransactionOutput::hasContractCall, this.translatingExtractor(CONTRACT_CALL_EXTRACTOR, context, logs), outputs));
                    break;
                }
                if (function == HederaFunctionality.CONTRACT_CREATE) {
                    recordBuilder.contractCreateResult(BlockItemsTranslator.outputValueIfPresent(TransactionOutput::hasContractCreate, this.translatingExtractor(CONTRACT_CREATE_EXTRACTOR, context, logs), outputs));
                    break;
                }
                if (function != HederaFunctionality.ETHEREUM_TRANSACTION) break;
                recordBuilder.ethereumHash(((ContractOpContext)context).ethHash());
                EthereumOutput ethOutput = BlockItemsTranslator.outputValueIfPresent(TransactionOutput::hasEthereumCall, TransactionOutput::ethereumCallOrThrow, outputs);
                if (ethOutput != null) {
                    switch ((EthereumOutput.TransactionResultOneOfType)ethOutput.transactionResult().kind()) {
                        case EVM_CALL_TRANSACTION_RESULT: {
                            recordBuilder.contractCallResult(this.legacyResultFrom(ethOutput.evmCallTransactionResultOrThrow(), context, logs));
                            break;
                        }
                        case EVM_CREATE_TRANSACTION_RESULT: {
                            recordBuilder.contractCreateResult(this.legacyResultFrom(ethOutput.evmCreateTransactionResultOrThrow(), context, logs));
                        }
                    }
                }
                break;
            }
            default: {
                ContractFunctionResult synthResult = BlockItemsTranslator.outputValueIfPresent(TransactionOutput::hasContractCall, this.translatingExtractor(CONTRACT_CALL_EXTRACTOR, context, null), outputs);
                if (synthResult != null) {
                    recordBuilder.contractCallResult(synthResult);
                }
                switch (function) {
                    case CRYPTO_CREATE: 
                    case CRYPTO_UPDATE: {
                        recordBuilder.evmAddress(((CryptoOpContext)context).evmAddress());
                        break block0;
                    }
                    case TOKEN_AIRDROP: {
                        recordBuilder.newPendingAirdrops(((AirdropOpContext)context).pendingAirdropRecords());
                        break block0;
                    }
                    case UTIL_PRNG: {
                        UtilPrngOutput prngOutput = BlockItemsTranslator.outputValueIfPresent(TransactionOutput::hasUtilPrng, TransactionOutput::utilPrngOrThrow, outputs);
                        if (prngOutput == null) break block0;
                        switch ((UtilPrngOutput.EntropyOneOfType)prngOutput.entropy().kind()) {
                            case PRNG_BYTES: {
                                recordBuilder.prngBytes(prngOutput.prngBytesOrThrow());
                                break block0;
                            }
                            case PRNG_NUMBER: {
                                recordBuilder.prngNumber(prngOutput.prngNumberOrThrow().intValue());
                            }
                        }
                    }
                }
            }
        }
        return recordBuilder.receipt(this.translateReceipt(context, result, outputs)).build();
    }

    private Function<TransactionOutput, ContractFunctionResult> translatingExtractor(@NonNull Function<TransactionOutput, EvmTransactionResult> extractor, @NonNull TranslationContext context, @Nullable List<EvmTransactionLog> logs) {
        return output -> this.legacyResultFrom((EvmTransactionResult)extractor.apply((TransactionOutput)output), context, logs);
    }

    private ContractFunctionResult legacyResultFrom(@NonNull EvmTransactionResult result, @NonNull TranslationContext context, @Nullable List<EvmTransactionLog> logs) {
        InternalCallContext callContext;
        ContractFunctionResult.Builder builder = ContractFunctionResult.newBuilder().senderId(result.senderId()).contractID(result.contractId()).contractCallResult(result.resultData()).errorMessage(result.errorMessage()).gasUsed(result.gasUsed());
        if (result.hasInternalCallContext()) {
            v0 = result.internalCallContextOrThrow();
        } else if (context instanceof ContractOpContext) {
            ContractOpContext contractOpContext = (ContractOpContext)context;
            v0 = contractOpContext.ethCallContext();
        } else {
            v0 = callContext = null;
        }
        if (callContext != null) {
            builder.gas(callContext.gas()).amount(callContext.value()).functionParameters(callContext.callData());
        }
        if (context instanceof ContractOpContext) {
            List<ContractNonceInfo> changedNonceInfos;
            ContractOpContext contractContext = (ContractOpContext)context;
            builder.signerNonce(contractContext.senderNonce());
            if (contractContext.createdContractIds() != null) {
                builder.createdContractIDs(contractContext.createdContractIds());
            }
            if (contractContext.evmAddress() != null) {
                builder.evmAddress(contractContext.evmAddress());
            }
            if ((changedNonceInfos = contractContext.changedNonceInfos()) != null && !changedNonceInfos.isEmpty()) {
                ArrayList<ContractNonceInfo> infos = new ArrayList<ContractNonceInfo>(changedNonceInfos);
                infos.sort(ContractChangeSummary.NONCE_INFO_CONTRACT_ID_COMPARATOR);
                builder.contractNonces(infos);
            }
            this.attachLogsTo(builder, logs);
        }
        return builder.build();
    }

    private void attachLogsTo(@NonNull ContractFunctionResult.Builder builder, @Nullable List<EvmTransactionLog> logs) {
        if (logs != null && !logs.isEmpty()) {
            ArrayList<Log> besuLogs = new ArrayList<Log>(logs.size());
            ArrayList<ContractLoginfo> verboseLogs = new ArrayList<ContractLoginfo>(logs.size());
            for (EvmTransactionLog log : logs) {
                List<Bytes> paddedTopics = log.topics().stream().map(HookUtils::leftPad32).toList();
                Log besuLog = ConversionUtils.asBesuLog((EvmTransactionLog)log, paddedTopics);
                besuLogs.add(besuLog);
                verboseLogs.add(ContractLoginfo.newBuilder().contractID(log.contractIdOrThrow()).topic(paddedTopics).bloom(ConversionUtils.bloomFor((Log)besuLog)).data(log.data()).build());
            }
            builder.bloom(ConversionUtils.bloomForAll(besuLogs)).logInfo(verboseLogs);
        }
    }

    @Nullable
    private static <T> T outputValueIfPresent(@NonNull Predicate<TransactionOutput> filter, @NonNull Function<TransactionOutput, T> extractor, TransactionOutput ... outputs) {
        for (TransactionOutput output : outputs) {
            if (!filter.test(output)) continue;
            return extractor.apply(output);
        }
        return null;
    }
}

