/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.history.impl;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.history.ConstructionNodeId;
import com.hedera.hapi.node.state.history.HistoryProof;
import com.hedera.hapi.node.state.history.HistoryProofConstruction;
import com.hedera.hapi.node.state.history.HistoryProofVote;
import com.hedera.hapi.node.state.history.ProofKeySet;
import com.hedera.hapi.node.state.history.WrapsMessageHistory;
import com.hedera.hapi.node.state.history.WrapsSigningState;
import com.hedera.hapi.node.state.primitives.ProtoBytes;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.hedera.hapi.platform.state.NodeId;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.history.ReadableHistoryStore;
import com.hedera.node.app.history.WritableHistoryStore;
import com.hedera.node.app.history.impl.ProofControllers;
import com.hedera.node.app.history.impl.ReadableHistoryStoreImpl;
import com.hedera.node.app.history.schemas.V071HistorySchema;
import com.hedera.node.app.service.roster.impl.ActiveRosters;
import com.hedera.node.config.data.TssConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableKVState;
import com.swirlds.state.spi.WritableSingletonState;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.roster.RosterUtils;

public class WritableHistoryStoreImpl
extends ReadableHistoryStoreImpl
implements WritableHistoryStore {
    private static final Logger log = LogManager.getLogger(WritableHistoryStoreImpl.class);
    private final WritableSingletonState<ProtoBytes> ledgerId;
    private final WritableSingletonState<HistoryProofConstruction> nextConstruction;
    private final WritableSingletonState<HistoryProofConstruction> activeConstruction;
    private final WritableKVState<NodeId, ProofKeySet> proofKeySets;
    private final WritableKVState<ConstructionNodeId, HistoryProofVote> votes;
    private final WritableKVState<ConstructionNodeId, WrapsMessageHistory> wrapsMessageHistories;

    public WritableHistoryStoreImpl(@NonNull WritableStates states) {
        super((ReadableStates)states);
        this.ledgerId = states.getSingleton(V071HistorySchema.LEDGER_ID_STATE_ID);
        this.nextConstruction = states.getSingleton(V071HistorySchema.NEXT_PROOF_CONSTRUCTION_STATE_ID);
        this.activeConstruction = states.getSingleton(V071HistorySchema.ACTIVE_PROOF_CONSTRUCTION_STATE_ID);
        this.proofKeySets = states.get(V071HistorySchema.PROOF_KEY_SETS_STATE_ID);
        this.votes = states.get(V071HistorySchema.PROOF_VOTES_STATE_ID);
        this.wrapsMessageHistories = states.get(V071HistorySchema.WRAPS_MESSAGE_HISTORIES_STATE_ID);
    }

    @Override
    @NonNull
    public HistoryProofConstruction getOrCreateConstruction(@NonNull ActiveRosters activeRosters, @NonNull Instant now, @NonNull TssConfig tssConfig) {
        Objects.requireNonNull(activeRosters);
        Objects.requireNonNull(now);
        Objects.requireNonNull(tssConfig);
        ActiveRosters.Phase phase = activeRosters.phase();
        if (phase == ActiveRosters.Phase.HANDOFF) {
            throw new IllegalArgumentException("Handoff phase has no construction");
        }
        HistoryProofConstruction construction = this.getConstructionFor(activeRosters);
        if (construction == null) {
            Duration gracePeriod = phase == ActiveRosters.Phase.BOOTSTRAP ? tssConfig.bootstrapProofKeyGracePeriod() : tssConfig.transitionProofKeyGracePeriod();
            construction = this.updateForNewConstruction(activeRosters.sourceRosterHash(), activeRosters.targetRosterHash(), arg_0 -> ((ActiveRosters)activeRosters).findRelatedRoster(arg_0), now, gracePeriod);
        }
        return construction;
    }

    @Override
    public boolean setProofKey(long nodeId, @NonNull Bytes proofKey, @NonNull Instant now) {
        Objects.requireNonNull(proofKey);
        Objects.requireNonNull(now);
        NodeId id = new NodeId(nodeId);
        ProofKeySet keySet = (ProofKeySet)this.proofKeySets.get((Object)id);
        boolean inUse = false;
        if (keySet == null) {
            inUse = true;
            keySet = ProofKeySet.newBuilder().key(proofKey).adoptionTime(HapiUtils.asTimestamp((Instant)now)).build();
        } else {
            keySet = keySet.copyBuilder().nextKey(proofKey).build();
        }
        this.proofKeySets.put((Object)id, (Object)keySet);
        return inUse;
    }

    @Override
    public HistoryProofConstruction setAssemblyTime(long constructionId, @NonNull Instant now) {
        Objects.requireNonNull(now);
        return this.updateOrThrow(constructionId, (c, b) -> b.assemblyStartTime(HapiUtils.asTimestamp((Instant)now)));
    }

    @Override
    public void addProofVote(long nodeId, long constructionId, @NonNull HistoryProofVote vote) {
        Objects.requireNonNull(vote);
        this.votes.put((Object)new ConstructionNodeId(constructionId, nodeId), (Object)vote);
    }

    @Override
    public void addWrapsMessage(long constructionId, @NonNull ReadableHistoryStore.WrapsMessagePublication publication) {
        Objects.requireNonNull(publication);
        ConstructionNodeId key = new ConstructionNodeId(constructionId, publication.nodeId());
        WrapsMessageHistory history = (WrapsMessageHistory)this.wrapsMessageHistories.get((Object)key);
        if (history == null) {
            this.wrapsMessageHistories.put((Object)key, (Object)new WrapsMessageHistory(List.of(publication.asWrapsMessageDetails())));
        } else {
            this.wrapsMessageHistories.put((Object)key, (Object)new WrapsMessageHistory(Stream.concat(history.messages().stream(), Stream.of(publication.asWrapsMessageDetails())).toList()));
        }
    }

    @Override
    public void updateWrapsSigningState(long constructionId, @NonNull Consumer<WrapsSigningState.Builder> spec) {
        Objects.requireNonNull(spec);
        this.updateOrThrow(constructionId, (c, b) -> {
            WrapsSigningState.Builder sb = c.wrapsSigningStateOrElse(WrapsSigningState.DEFAULT).copyBuilder();
            spec.accept(sb);
            return b.wrapsSigningState(sb.build());
        });
    }

    @Override
    public HistoryProofConstruction completeProof(long constructionId, @NonNull HistoryProof proof) {
        Objects.requireNonNull(proof);
        return this.updateOrThrow(constructionId, (c, b) -> b.targetProof(proof));
    }

    @Override
    public HistoryProofConstruction failForReason(long constructionId, @NonNull String reason) {
        Objects.requireNonNull(reason);
        return this.updateOrThrow(constructionId, (c, b) -> b.failureReason(reason));
    }

    @Override
    public void setLedgerId(@NonNull Bytes bytes) {
        Objects.requireNonNull(bytes);
        this.ledgerId.put((Object)new ProtoBytes(bytes));
    }

    @Override
    public boolean handoff(@NonNull Roster fromRoster, @Nullable Roster toRoster, @Nullable Bytes toRosterHash) {
        if (toRosterHash == null || Objects.requireNonNull((HistoryProofConstruction)this.nextConstruction.get()).targetRosterHash().equals((Object)toRosterHash)) {
            HistoryProofConstruction upcomingConstruction = Objects.requireNonNull((HistoryProofConstruction)this.activeConstruction.get());
            log.info("Handing off to upcoming construction #{}", (Object)upcomingConstruction.constructionId());
            this.purgePublications(upcomingConstruction.constructionId(), fromRoster);
            if (toRoster != null && fromRoster != toRoster && !RosterUtils.isWeightRotation((Roster)fromRoster, (Roster)toRoster)) {
                Set survivingNodeIds = toRoster.rosterEntries().stream().map(RosterEntry::nodeId).collect(Collectors.toSet());
                fromRoster.rosterEntries().forEach(entry -> {
                    long nodeId = entry.nodeId();
                    if (!survivingNodeIds.contains(nodeId)) {
                        this.proofKeySets.remove((Object)new NodeId(nodeId));
                    }
                });
            }
            this.activeConstruction.put((Object)((HistoryProofConstruction)this.nextConstruction.get()));
            this.nextConstruction.put((Object)HistoryProofConstruction.DEFAULT);
            return true;
        }
        return false;
    }

    private HistoryProofConstruction updateOrThrow(long constructionId, @NonNull BiFunction<HistoryProofConstruction, HistoryProofConstruction.Builder, HistoryProofConstruction.Builder> spec) {
        HistoryProofConstruction construction = (HistoryProofConstruction)this.activeConstruction.get();
        if (Objects.requireNonNull(construction).constructionId() == constructionId) {
            construction = spec.apply(construction, construction.copyBuilder()).build();
            this.activeConstruction.put((Object)construction);
        } else {
            construction = (HistoryProofConstruction)this.nextConstruction.get();
            if (Objects.requireNonNull(construction).constructionId() == constructionId) {
                construction = spec.apply(construction, construction.copyBuilder()).build();
                this.nextConstruction.put((Object)construction);
            } else {
                throw new IllegalArgumentException("No construction with id " + constructionId);
            }
        }
        return construction;
    }

    private HistoryProofConstruction updateForNewConstruction(@NonNull Bytes sourceRosterHash, @NonNull Bytes targetRosterHash, @NonNull Function<Bytes, Roster> lookup, @NonNull Instant now, @NonNull Duration gracePeriod) {
        HistoryProofConstruction construction = HistoryProofConstruction.newBuilder().constructionId(this.newConstructionId()).sourceRosterHash(sourceRosterHash).targetRosterHash(targetRosterHash).gracePeriodEndTime(HapiUtils.asTimestamp((Instant)now.plus(gracePeriod))).build();
        if (Objects.requireNonNull((HistoryProofConstruction)this.activeConstruction.get()).equals((Object)HistoryProofConstruction.DEFAULT)) {
            this.activeConstruction.put((Object)construction);
            this.logNewConstruction(construction, InSlot.ACTIVE, sourceRosterHash, targetRosterHash);
        } else {
            if (!Objects.requireNonNull((HistoryProofConstruction)this.nextConstruction.get()).equals((Object)HistoryProofConstruction.DEFAULT)) {
                HistoryProofConstruction extantConstruction = Objects.requireNonNull((HistoryProofConstruction)this.nextConstruction.get());
                Roster sourceRoster = Objects.requireNonNull(lookup.apply(extantConstruction.sourceRosterHash()));
                this.purgePublications(extantConstruction.constructionId(), sourceRoster);
            }
            this.nextConstruction.put((Object)construction);
            this.logNewConstruction(construction, InSlot.NEXT, sourceRosterHash, targetRosterHash);
        }
        Timestamp adoptionTime = HapiUtils.asTimestamp((Instant)now);
        Roster targetRoster = Objects.requireNonNull(lookup.apply(targetRosterHash));
        targetRoster.rosterEntries().forEach(entry -> {
            NodeId nodeId = new NodeId(entry.nodeId());
            ProofKeySet keySet = (ProofKeySet)this.proofKeySets.get((Object)nodeId);
            if (keySet != null && keySet.nextKey().length() > 0L) {
                ProofKeySet rotatedKeySet = keySet.copyBuilder().key(keySet.nextKey()).adoptionTime(adoptionTime).nextKey(Bytes.EMPTY).build();
                this.proofKeySets.put((Object)nodeId, (Object)rotatedKeySet);
            }
        });
        return construction;
    }

    private void logNewConstruction(@NonNull HistoryProofConstruction construction, @NonNull InSlot slot, @NonNull Bytes sourceRosterHash, @NonNull Bytes targetRosterHash) {
        HistoryProofConstruction ac = Objects.requireNonNull((HistoryProofConstruction)this.activeConstruction.get());
        log.info("Created {} construction #{} for rosters (source={}, target={}) {} source proof", (Object)slot, (Object)construction.constructionId(), (Object)sourceRosterHash, (Object)targetRosterHash, ac.hasTargetProof() ? "WITH" + (ProofControllers.isWrapsExtensible(ac.targetProofOrThrow()) ? " WRAPS-extensible" : "") : "WITHOUT");
    }

    private void purgePublications(long constructionId, @NonNull Roster sourceRoster) {
        sourceRoster.rosterEntries().forEach(entry -> {
            ConstructionNodeId key = new ConstructionNodeId(constructionId, entry.nodeId());
            this.votes.remove((Object)key);
            this.wrapsMessageHistories.remove((Object)key);
        });
    }

    private long newConstructionId() {
        return Math.max(Objects.requireNonNull((HistoryProofConstruction)this.activeConstruction.get()).constructionId(), Objects.requireNonNull((HistoryProofConstruction)this.nextConstruction.get()).constructionId()) + 1L;
    }

    private static enum InSlot {
        ACTIVE,
        NEXT;

    }
}

