/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.util;

import com.swirlds.base.time.Time;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.config.api.Configuration;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.state.snapshot.DeserializedSignedState;
import com.swirlds.platform.system.SwirldMain;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.metrics.noop.NoOpMetrics;

public class HederaUtils {
    public static final String HEDERA_MAIN_CLASS = "com.hedera.node.app.ServicesMain";
    public static final String SWIRLD_NAME = "123";

    public static SwirldMain createHederaAppMain(@NonNull PlatformContext platformContext) {
        try {
            Class<?> mainClass = Class.forName(HEDERA_MAIN_CLASS);
            Method newHederaMethod = mainClass.getDeclaredMethod("newHedera", Configuration.class, Metrics.class, Time.class);
            return (SwirldMain)newHederaMethod.invoke(null, platformContext.getConfiguration(), new NoOpMetrics(), platformContext.getTime());
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static void updateStateHash(@NonNull SwirldMain hederaApp, @NonNull DeserializedSignedState deserializedSignedState) {
        try {
            Method setInitialStateHash = hederaApp.getClass().getDeclaredMethod("setInitialStateHash", Hash.class);
            setInitialStateHash.invoke((Object)hederaApp, deserializedSignedState.originalHash());
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

