/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.configurable;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.common.configurable.LruCache;
import io.helidon.common.configurable.LruCacheConfigBlueprint;
import io.helidon.config.ConfigBuilderSupport;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.common.configurable.LruCacheConfigBlueprint<K, V>")
public interface LruCacheConfig<K, V>
extends LruCacheConfigBlueprint<K, V>,
Prototype.Api {
    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static <K, V> Builder<K, V> builder(LruCacheConfig<K, V> instance) {
        return (Builder)LruCacheConfig.builder().from(instance);
    }

    public static <K, V> LruCacheConfig<K, V> create(io.helidon.config.Config config) {
        return ((Builder)LruCacheConfig.builder().config(config)).buildPrototype();
    }

    @Deprecated
    public static <K, V> LruCacheConfig<K, V> create(Config config) {
        return LruCacheConfig.create(io.helidon.config.Config.config((Config)config));
    }

    public static <K, V> LruCacheConfig<K, V> create() {
        return LruCacheConfig.builder().buildPrototype();
    }

    @Override
    public int capacity();

    public static class Builder<K, V>
    extends BuilderBase<K, V, Builder<K, V>, LruCacheConfig<K, V>>
    implements io.helidon.common.Builder<Builder<K, V>, LruCache<K, V>> {
        private Builder() {
        }

        public LruCacheConfig<K, V> buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.LruCacheConfigImpl(this);
        }

        public LruCache<K, V> build() {
            return LruCache.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<K, V, BUILDER extends BuilderBase<K, V, BUILDER, PROTOTYPE>, PROTOTYPE extends LruCacheConfig<K, V>>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private io.helidon.config.Config config;
        private int capacity = 10000;

        protected BuilderBase() {
        }

        public BUILDER from(LruCacheConfig<K, V> prototype) {
            this.capacity(prototype.capacity());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<K, V, ?, ?> builder) {
            this.capacity(builder.capacity());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated
        public BUILDER config(Config config) {
            return (BUILDER)this.config(io.helidon.config.Config.config((Config)config));
        }

        public BUILDER config(io.helidon.config.Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("capacity").as(Integer.class).ifPresent(this::capacity);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER capacity(int capacity) {
            this.capacity = capacity;
            return (BUILDER)((BuilderBase)this.self());
        }

        public int capacity() {
            return this.capacity;
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "LruCacheConfigBuilder{capacity=" + this.capacity + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        protected static class LruCacheConfigImpl<K, V>
        implements LruCacheConfig<K, V>,
        Supplier<LruCache<K, V>> {
            private final int capacity;

            protected LruCacheConfigImpl(BuilderBase<K, V, ?, ?> builder) {
                this.capacity = builder.capacity();
            }

            public LruCache<K, V> build() {
                return LruCache.create(this);
            }

            @Override
            public LruCache<K, V> get() {
                return this.build();
            }

            @Override
            public int capacity() {
                return this.capacity;
            }

            public String toString() {
                return "LruCacheConfig{capacity=" + this.capacity + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof LruCacheConfig)) {
                    return false;
                }
                LruCacheConfig other = (LruCacheConfig)o;
                return this.capacity == other.capacity();
            }

            public int hashCode() {
                return Objects.hash(this.capacity);
            }
        }
    }
}

