/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.concurrent.framework.config;

import java.util.concurrent.ThreadFactory;
import org.hiero.consensus.concurrent.framework.ThreadSeed;
import org.hiero.consensus.concurrent.framework.internal.AbstractThreadConfiguration;
import org.hiero.consensus.concurrent.manager.ThreadManager;

public class ThreadConfiguration
extends AbstractThreadConfiguration<ThreadConfiguration> {
    public ThreadConfiguration(ThreadManager threadManager) {
        super(threadManager);
    }

    private ThreadConfiguration(ThreadConfiguration that) {
        super(that);
    }

    @Override
    public ThreadConfiguration copy() {
        return new ThreadConfiguration(this);
    }

    public static ThreadConfiguration captureThreadConfiguration(ThreadManager threadManager) {
        return ThreadConfiguration.captureThreadConfiguration(threadManager, Thread.currentThread());
    }

    public static ThreadConfiguration captureThreadConfiguration(ThreadManager threadManager, Thread thread) {
        ThreadConfiguration configuration = new ThreadConfiguration(threadManager);
        configuration.copyThreadConfiguration(thread);
        return configuration;
    }

    public Thread build() {
        return this.build(false);
    }

    public Thread build(boolean start) {
        this.becomeImmutable();
        return this.buildThread(start);
    }

    public ThreadFactory buildFactory() {
        this.enableThreadNumbering();
        AbstractThreadConfiguration.ContextSnapshot snapshot = this.captureContextSnapshot();
        ThreadFactory factory = r -> {
            Runnable contextAwareRunnable = this.wrapRunnableWithSnapshot(r, snapshot);
            Thread thread = this.getThreadManager().createThread(this.getThreadGroup(), contextAwareRunnable);
            this.configureThread(thread);
            return thread;
        };
        this.becomeImmutable();
        return factory;
    }

    public ThreadSeed buildSeed() {
        this.becomeImmutable();
        return this.buildThreadSeed();
    }

    @Override
    public Runnable getRunnable() {
        return super.getRunnable();
    }

    @Override
    public ThreadConfiguration setRunnable(Runnable runnable) {
        return (ThreadConfiguration)super.setRunnable(runnable);
    }
}

