/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import java.util.function.Supplier;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.hyperledger.besu.crypto.Hash;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractCreateOperation;

public class EOFCreateOperation
extends AbstractCreateOperation {
    public static final int OPCODE = 236;
    private static final Bytes PREFIX = Bytes.fromHexString((CharSequence)"0xFF");

    public EOFCreateOperation(GasCalculator gasCalculator) {
        super(236, "EOFCREATE", 4, 1, gasCalculator, 1);
    }

    @Override
    public long cost(MessageFrame frame, Supplier<Code> codeSupplier) {
        long inputOffset = Words.clampedToLong(frame.getStackItem(2));
        long inputSize = Words.clampedToLong(frame.getStackItem(3));
        return Words.clampedAdd(this.gasCalculator().memoryExpansionGasCost(frame, inputOffset, inputSize), Words.clampedAdd(this.gasCalculator().txCreateCost(), this.gasCalculator().createKeccakCost(codeSupplier.get().getSize())));
    }

    @Override
    public Address generateTargetContractAddress(MessageFrame frame, Code initcode) {
        Address sender = frame.getRecipientAddress();
        Bytes32 salt = Bytes32.leftPad((Bytes)frame.getStackItem(1));
        Bytes32 hash = Hash.keccak256((Bytes)Bytes.concatenate((Bytes[])new Bytes[]{PREFIX, sender, salt, initcode.getCodeHash()}));
        return Address.extract((Bytes32)hash);
    }

    @Override
    protected Code getInitCode(MessageFrame frame, EVM evm) {
        Code code = frame.getCode();
        int startIndex = frame.getPC() + 1;
        int initContainerIndex = code.readU8(startIndex);
        return code.getSubContainer(initContainerIndex, null, evm).orElse(null);
    }

    @Override
    protected Bytes getInputData(MessageFrame frame) {
        long inputOffset = Words.clampedToLong(frame.getStackItem(2));
        long inputSize = Words.clampedToLong(frame.getStackItem(3));
        return frame.readMemory(inputOffset, inputSize);
    }

    @Override
    protected int getPcIncrement() {
        return 2;
    }

    @Override
    protected void fail(MessageFrame frame) {
        long inputOffset = Words.clampedToLong(frame.getStackItem(2));
        long inputSize = Words.clampedToLong(frame.getStackItem(3));
        frame.readMutableMemory(inputOffset, inputSize);
        frame.popStackItems(this.getStackItemsConsumed());
        frame.pushStackItem(Bytes.EMPTY);
    }
}

