/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import java.math.BigInteger;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class SLtOperation
extends AbstractFixedCostOperation {
    static final Operation.OperationResult sltSuccess = new Operation.OperationResult(3L, null);

    public SLtOperation(GasCalculator gasCalculator) {
        super(18, "SLT", 2, 1, gasCalculator, gasCalculator.getVeryLowTierGasCost());
    }

    @Override
    public Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        return SLtOperation.staticOperation(frame);
    }

    public static Operation.OperationResult staticOperation(MessageFrame frame) {
        Bytes value0 = frame.popStackItem();
        Bytes value1 = frame.popStackItem();
        BigInteger b0 = value0.size() < 32 ? new BigInteger(1, value0.toArrayUnsafe()) : new BigInteger(value0.toArrayUnsafe());
        BigInteger b1 = value1.size() < 32 ? new BigInteger(1, value1.toArrayUnsafe()) : new BigInteger(value1.toArrayUnsafe());
        Bytes result = b0.compareTo(b1) < 0 ? BYTES_ONE : Bytes.EMPTY;
        frame.pushStackItem(result);
        return sltSuccess;
    }
}

