/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.tracing;

import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.List;
import org.apache.tuweni.bytes.Bytes32;
import org.hyperledger.besu.datatypes.AccessListEntry;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.operation.Operation;
import org.hyperledger.besu.evm.tracing.EstimateGasOperationTracer;

public class AccessListOperationTracer
extends EstimateGasOperationTracer {
    private Table<Address, Bytes32, Boolean> warmedUpStorage;

    private AccessListOperationTracer() {
    }

    @Override
    public void tracePostExecution(MessageFrame frame, Operation.OperationResult operationResult) {
        super.tracePostExecution(frame, operationResult);
        this.warmedUpStorage = frame.getWarmedUpStorage();
    }

    public List<AccessListEntry> getAccessList() {
        if (this.warmedUpStorage != null && !this.warmedUpStorage.isEmpty()) {
            ArrayList<AccessListEntry> list = new ArrayList<AccessListEntry>(this.warmedUpStorage.size());
            this.warmedUpStorage.rowMap().forEach((address, storageKeys) -> list.add(new AccessListEntry(address, new ArrayList(storageKeys.keySet()))));
            return list;
        }
        return List.of();
    }

    public static AccessListOperationTracer create() {
        return new AccessListOperationTracer();
    }
}

