/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.blocks.impl.streaming.config;

import com.hedera.node.internal.network.HelidonGrpcConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.helidon.webclient.grpc.GrpcClientProtocolConfig;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

public class BlockNodeHelidonGrpcConfiguration {
    public static final BlockNodeHelidonGrpcConfiguration DEFAULT = BlockNodeHelidonGrpcConfiguration.newBuilder().build();
    private final Boolean abortPollTimeExpired;
    private final Duration heartbeatPeriod;
    private final Integer initialBufferSize;
    private final String name;
    private final Duration pollWaitTime;

    private BlockNodeHelidonGrpcConfiguration(Builder builder) {
        this.abortPollTimeExpired = builder.abortPollTimeExpired;
        this.heartbeatPeriod = builder.heartbeatPeriod;
        this.initialBufferSize = builder.initialBufferSize;
        this.name = builder.name;
        this.pollWaitTime = builder.pollWaitTime;
    }

    @NonNull
    public Optional<Boolean> abortPollTimeExpired() {
        return Optional.ofNullable(this.abortPollTimeExpired);
    }

    @NonNull
    public Optional<Duration> heartbeatPeriod() {
        return Optional.ofNullable(this.heartbeatPeriod);
    }

    @NonNull
    public Optional<Integer> initialBufferSize() {
        return Optional.ofNullable(this.initialBufferSize);
    }

    @NonNull
    public Optional<String> name() {
        return Optional.ofNullable(this.name);
    }

    @NonNull
    public Optional<Duration> pollWaitTime() {
        return Optional.ofNullable(this.pollWaitTime);
    }

    @NonNull
    public GrpcClientProtocolConfig toGrpcClientProtocolConfig() {
        GrpcClientProtocolConfig.Builder b = GrpcClientProtocolConfig.builder();
        this.abortPollTimeExpired().ifPresent(arg_0 -> ((GrpcClientProtocolConfig.Builder)b).abortPollTimeExpired(arg_0));
        this.heartbeatPeriod().ifPresent(arg_0 -> ((GrpcClientProtocolConfig.Builder)b).heartbeatPeriod(arg_0));
        this.initialBufferSize().ifPresent(arg_0 -> ((GrpcClientProtocolConfig.Builder)b).initBufferSize(arg_0));
        this.name().ifPresent(arg_0 -> ((GrpcClientProtocolConfig.Builder)b).name(arg_0));
        this.pollWaitTime().ifPresent(arg_0 -> ((GrpcClientProtocolConfig.Builder)b).pollWaitTime(arg_0));
        return b.build();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockNodeHelidonGrpcConfiguration that = (BlockNodeHelidonGrpcConfiguration)o;
        return Objects.equals(this.abortPollTimeExpired, that.abortPollTimeExpired) && Objects.equals(this.heartbeatPeriod, that.heartbeatPeriod) && Objects.equals(this.initialBufferSize, that.initialBufferSize) && Objects.equals(this.name, that.name) && Objects.equals(this.pollWaitTime, that.pollWaitTime);
    }

    public int hashCode() {
        return Objects.hash(this.abortPollTimeExpired, this.heartbeatPeriod, this.initialBufferSize, this.name, this.pollWaitTime);
    }

    public String toString() {
        return "BlockNodeHelidonGrpcConfiguration{abortPollTimeExpired=" + this.abortPollTimeExpired + ", heartbeatPeriod=" + String.valueOf(this.heartbeatPeriod) + ", initialBufferSize=" + this.initialBufferSize + ", name=" + (this.name == null ? null : "'" + this.name + "'") + ", pollWaitTime=" + String.valueOf(this.pollWaitTime) + "}";
    }

    @NonNull
    public static Builder newBuilder() {
        return new Builder();
    }

    @NonNull
    public static BlockNodeHelidonGrpcConfiguration from(@Nullable HelidonGrpcConfig grpcConfig) {
        if (grpcConfig == null) {
            return DEFAULT;
        }
        Builder b = BlockNodeHelidonGrpcConfiguration.newBuilder();
        b.abortPollTimeExpired(grpcConfig.abortPollTimeExpired());
        String _heartbeatPeriod = grpcConfig.heartbeatPeriod();
        if (_heartbeatPeriod != null && !_heartbeatPeriod.isBlank()) {
            b.heartbeatPeriod(Duration.parse(_heartbeatPeriod));
        }
        b.initialBufferSize(grpcConfig.initBufferSize());
        b.name(grpcConfig.name());
        String _pollWaitTime = grpcConfig.pollWaitTime();
        if (_pollWaitTime != null && !_pollWaitTime.isBlank()) {
            b.pollWaitTime(Duration.parse(_pollWaitTime));
        }
        return b.build();
    }

    public static class Builder {
        private Boolean abortPollTimeExpired;
        private Duration heartbeatPeriod;
        private Integer initialBufferSize;
        private String name;
        private Duration pollWaitTime;

        private Builder() {
        }

        @NonNull
        public Builder abortPollTimeExpired(@Nullable Boolean abortPollTimeExpired) {
            this.abortPollTimeExpired = abortPollTimeExpired;
            return this;
        }

        @NonNull
        public Builder heartbeatPeriod(@Nullable Duration heartbeatPeriod) {
            this.heartbeatPeriod = heartbeatPeriod;
            return this;
        }

        @NonNull
        public Builder initialBufferSize(@Nullable Integer initialBufferSize) {
            this.initialBufferSize = initialBufferSize;
            return this;
        }

        @NonNull
        public Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @NonNull
        public Builder pollWaitTime(@Nullable Duration pollWaitTime) {
            this.pollWaitTime = pollWaitTime;
            return this;
        }

        public BlockNodeHelidonGrpcConfiguration build() {
            return new BlockNodeHelidonGrpcConfiguration(this);
        }
    }
}

