/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hints.handlers;

import com.hedera.hapi.services.auxiliary.hints.HintsKeyPublicationTransactionBody;
import com.hedera.node.app.hints.ReadableHintsStore;
import com.hedera.node.app.hints.WritableHintsStore;
import com.hedera.node.app.hints.impl.HintsControllers;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class HintsKeyPublicationHandler
implements TransactionHandler {
    private static final Logger log = LogManager.getLogger(HintsKeyPublicationHandler.class);
    private static final int INVALID_PARTY_ID = -1;
    private final HintsControllers controllers;

    @Inject
    public HintsKeyPublicationHandler(@NonNull HintsControllers controllers) {
        this.controllers = Objects.requireNonNull(controllers);
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
    }

    public void handle(@NonNull HandleContext context) throws HandleException {
        Objects.requireNonNull(context);
        HintsKeyPublicationTransactionBody op = context.body().hintsKeyPublicationOrThrow();
        int numParties = op.numParties();
        this.controllers.getInProgressForNumParties(numParties).ifPresent(controller -> {
            long nodeId = context.creatorInfo().nodeId();
            int partyId = controller.partyIdOf(nodeId).orElse(-1);
            if (op.partyId() == partyId) {
                Instant adoptionTime;
                Bytes hintsKey = op.hintsKey();
                WritableHintsStore hintsStore = (WritableHintsStore)context.storeFactory().writableStore(WritableHintsStore.class);
                if (hintsStore.setHintsKey(nodeId, partyId, numParties, hintsKey, adoptionTime = context.consensusNow())) {
                    controller.addHintsKeyPublication(new ReadableHintsStore.HintsKeyPublication(nodeId, hintsKey, partyId, adoptionTime), hintsStore.getCrsState().crs());
                }
            } else {
                log.warn("Ignoring hinTS key from node{} (claimed party id {} instead of {})", (Object)nodeId, (Object)op.partyId(), (Object)partyId);
            }
        });
    }
}

