/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.reconnect.impl;

import com.swirlds.base.time.Time;
import com.swirlds.config.api.Configuration;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.metrics.ReconnectMetrics;
import com.swirlds.state.StateLifecycleManager;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.hiero.base.concurrent.BlockingResourceProvider;
import org.hiero.consensus.concurrent.manager.ThreadManager;
import org.hiero.consensus.gossip.ReservedSignedStateResult;
import org.hiero.consensus.gossip.impl.network.protocol.Protocol;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.status.PlatformStatus;
import org.hiero.consensus.monitoring.FallenBehindMonitor;
import org.hiero.consensus.reconnect.impl.ReconnectStatePeerProtocol;
import org.hiero.consensus.reconnect.impl.ReconnectStateTeacherThrottle;
import org.hiero.consensus.state.signed.ReservedSignedState;

public class ReconnectStateSyncProtocol
implements Protocol {
    private final ReconnectStateTeacherThrottle reconnectStateTeacherThrottle;
    private final Supplier<ReservedSignedState> lastCompleteSignedState;
    private final Duration reconnectSocketTimeout;
    private final ReconnectMetrics reconnectMetrics;
    private final ThreadManager threadManager;
    private final FallenBehindMonitor fallenBehindManager;
    private final Configuration configuration;
    private final Metrics metrics;
    private final Time time;
    private final AtomicReference<PlatformStatus> platformStatus = new AtomicReference<PlatformStatus>(PlatformStatus.STARTING_UP);
    private final BlockingResourceProvider<ReservedSignedStateResult> reservedSignedStateResultPromise;
    private final StateLifecycleManager stateLifecycleManager;

    public ReconnectStateSyncProtocol(@NonNull Configuration configuration, @NonNull Metrics metrics, @NonNull Time time, @NonNull ThreadManager threadManager, @NonNull ReconnectStateTeacherThrottle reconnectStateTeacherThrottle, @NonNull Supplier<ReservedSignedState> lastCompleteSignedState, @NonNull Duration reconnectSocketTimeout, @NonNull ReconnectMetrics reconnectMetrics, @NonNull FallenBehindMonitor fallenBehindManager, @NonNull BlockingResourceProvider<ReservedSignedStateResult> reservedSignedStateResultPromise, @NonNull StateLifecycleManager stateLifecycleManager) {
        this.configuration = Objects.requireNonNull(configuration);
        this.metrics = Objects.requireNonNull(metrics);
        this.time = Objects.requireNonNull(time);
        this.threadManager = Objects.requireNonNull(threadManager);
        this.reconnectStateTeacherThrottle = Objects.requireNonNull(reconnectStateTeacherThrottle);
        this.lastCompleteSignedState = Objects.requireNonNull(lastCompleteSignedState);
        this.reconnectSocketTimeout = Objects.requireNonNull(reconnectSocketTimeout);
        this.reconnectMetrics = Objects.requireNonNull(reconnectMetrics);
        this.fallenBehindManager = Objects.requireNonNull(fallenBehindManager);
        this.reservedSignedStateResultPromise = Objects.requireNonNull(reservedSignedStateResultPromise);
        this.stateLifecycleManager = Objects.requireNonNull(stateLifecycleManager);
    }

    @NonNull
    public ReconnectStatePeerProtocol createPeerInstance(@NonNull NodeId peerId) {
        return new ReconnectStatePeerProtocol(this.configuration, this.metrics, this.time, this.threadManager, Objects.requireNonNull(peerId), this.reconnectStateTeacherThrottle, this.lastCompleteSignedState, this.reconnectSocketTimeout, this.reconnectMetrics, this.fallenBehindManager, this.platformStatus::get, this.reservedSignedStateResultPromise, this.stateLifecycleManager);
    }

    public void updatePlatformStatus(@NonNull PlatformStatus status) {
        this.platformStatus.set(status);
    }
}

