/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.ArrayType;
import com.esaulpaugh.headlong.abi.IntType;
import com.esaulpaugh.headlong.abi.Tuple;
import com.esaulpaugh.headlong.abi.TypeFactory;
import com.esaulpaugh.headlong.util.FastHex;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.IntUnaryOperator;

public final class TupleType<J extends Tuple>
extends ABIType<J>
implements Iterable<ABIType<?>> {
    private static final boolean[] EMPTY_INDEX = new boolean[0];
    public static final TupleType<Tuple> EMPTY = new TupleType("()", false, EMPTY_ARRAY, null, null, EMPTY_INDEX, 0);
    private static final TupleType<Tuple> EMPTY_LEGACY = new TupleType("()", false, EMPTY_ARRAY, null, null, EMPTY_INDEX, 1);
    final ABIType<?>[] elementTypes;
    final String[] elementNames;
    final String[] elementInternalTypes;
    final boolean[] indexed;
    private final int[] elementHeadOffsets;
    final int headLengthSum;
    private final int flags;

    TupleType(String canonicalType, boolean dynamic, ABIType<?>[] elementTypes, String[] elementNames, String[] elementInternalTypes, boolean[] indexed, int flags) {
        super(canonicalType, Tuple.classFor(elementTypes.length), dynamic);
        if (elementNames != null && elementNames.length != elementTypes.length) {
            throw new IllegalArgumentException("expected " + elementTypes.length + " element names but found " + elementNames.length);
        }
        this.elementTypes = elementTypes;
        this.elementNames = elementNames;
        this.elementInternalTypes = elementInternalTypes;
        int[] elementHeadOffsets = new int[elementTypes.length];
        int headLengthSum = 0;
        int i = 0;
        while (i < elementTypes.length) {
            elementHeadOffsets[i] = headLengthSum;
            headLengthSum += elementTypes[i++].headLength();
        }
        this.elementHeadOffsets = elementHeadOffsets;
        this.headLengthSum = headLengthSum;
        this.indexed = indexed;
        this.flags = flags;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    public int size() {
        return this.elementTypes.length;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public String getElementName(int index) {
        return this.elementNames == null ? null : this.elementNames[index];
    }

    public String getElementInternalType(int index) {
        return this.elementInternalTypes == null ? null : this.elementInternalTypes[index];
    }

    public <T extends ABIType<?>> T get(int index) {
        return (T)this.elementTypes[index];
    }

    @Override
    Class<?> arrayClass() {
        return Tuple[].class;
    }

    @Override
    public int typeCode() {
        return 7;
    }

    @Override
    int headLength() {
        return this.dynamic ? 32 : this.headLengthSum;
    }

    @Override
    int dynamicByteLength(Tuple value) {
        return this.countBytes(i -> TupleType.measureObject(this.get(i), value.elements[i]));
    }

    @Override
    int byteLength(Tuple value) {
        if (!this.dynamic) {
            return this.headLengthSum;
        }
        return this.dynamicByteLength(value);
    }

    private static int measureObject(ABIType<Object> type, Object value) {
        return TupleType.totalLen(type.byteLength(value), type.dynamic);
    }

    @Override
    public int byteLengthPacked(Tuple value) {
        Object[] elements = value != null ? value.elements : new Object[this.size()];
        return this.countBytes(i -> ((ABIType)this.get(i)).byteLengthPacked((Object)elements[i]));
    }

    private int countBytes(IntUnaryOperator counter) {
        return TupleType.countBytes(true, this.size(), counter);
    }

    static int countBytes(boolean tuple, int len, IntUnaryOperator counter) {
        int i;
        try {
            int count = 0;
            for (i = 0; i < len; ++i) {
                count += counter.applyAsInt(i);
            }
            return count;
        }
        catch (IllegalArgumentException cause) {
            throw TupleType.exceptionWithIndex(tuple, i, cause);
        }
    }

    @Override
    public int validate(J value) {
        if (((Tuple)value).size() == this.size()) {
            return this.countBytes(i -> TupleType.validateObject(this.get(i), value.elements[i]));
        }
        throw this.lengthMismatch((Tuple)value);
    }

    private IllegalArgumentException lengthMismatch(Tuple args) {
        return new IllegalArgumentException("tuple length mismatch: expected length " + this.size() + " but found " + args.size());
    }

    private static <X> int validateObject(ABIType<X> type, X value) {
        try {
            return TupleType.totalLen(type.validate(value), type.dynamic);
        }
        catch (ClassCastException cce) {
            type.validateClass(value);
            throw new AssertionError();
        }
        catch (NullPointerException npe) {
            throw new IllegalArgumentException("null", npe);
        }
    }

    static int totalLen(int byteLen, boolean addUnit) {
        return addUnit ? 32 + byteLen : byteLen;
    }

    @Override
    void encodeTail(Tuple value, ByteBuffer dest) {
        if (this.dynamic) {
            this.encodeDynamic(value.elements, dest);
        } else {
            for (int i = 0; i < value.elements.length; ++i) {
                ((ABIType)this.get(i)).encodeTail((Object)value.elements[i], dest);
            }
        }
    }

    @Override
    void encodePackedUnchecked(Tuple value, ByteBuffer dest) {
        for (int i = 0; i < value.elements.length; ++i) {
            ((ABIType)this.get(i)).encodePackedUnchecked((Object)value.elements[i], dest);
        }
    }

    private void encodeDynamic(Object[] values, ByteBuffer dest) {
        Object t;
        int i = 0;
        int last = values.length - 1;
        int offset = this.headLengthSum;
        while (true) {
            t = this.get(i);
            if (!((ABIType)t).dynamic) {
                ((ABIType)t).encodeTail((Object)values[i], dest);
                if (i == last) {
                    break;
                }
            } else {
                TupleType.insertIntUnsigned(offset, dest);
                if (i == last) break;
                offset += ((ABIType)t).dynamicByteLength((Object)values[i]);
            }
            ++i;
        }
        i = 0;
        do {
            t = this.get(i);
            if (!((ABIType)t).dynamic) continue;
            ((ABIType)t).encodeTail((Object)values[i], dest);
        } while (++i < values.length);
    }

    @Override
    J decode(ByteBuffer bb, byte[] unitBuffer) {
        int i;
        Object[] elements = new Object[this.size()];
        try {
            if (!this.dynamic) {
                for (i = 0; i < elements.length; ++i) {
                    elements[i] = ((ABIType)this.get(i)).decode(bb, unitBuffer);
                }
            } else {
                int start = bb.position();
                int[] offsets = new int[elements.length];
                do {
                    Object t = this.get(i);
                    if (!((ABIType)t).dynamic) {
                        elements[i] = ((ABIType)t).decode(bb, unitBuffer);
                        continue;
                    }
                    offsets[i] = IntType.UINT30.decode(bb, unitBuffer) + 1;
                } while (++i < elements.length);
                i = 0;
                do {
                    int offset;
                    if ((offset = offsets[i]) == 0) continue;
                    int jump = start + offset - 1;
                    if (jump != bb.position()) {
                        bb.position(jump);
                    }
                    elements[i] = ((ABIType)this.get(i)).decode(bb, unitBuffer);
                } while (++i < elements.length);
            }
        }
        catch (IllegalArgumentException cause) {
            throw TupleType.exceptionWithIndex(true, i, cause);
        }
        return Tuple.create(elements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T decode(ByteBuffer bb, int ... indices) {
        bb.mark();
        try {
            if (indices.length == 1) {
                Object object = this.decodeIndex(bb, bb.position(), TupleType.newUnitBuffer(), indices[0]);
                return (T)object;
            }
            J j = this.decodeIndices(bb, indices);
            return (T)j;
        }
        finally {
            bb.reset();
        }
    }

    private Object decodeIndex(ByteBuffer bb, int start, byte[] unitBuffer, int i) {
        try {
            Object t = this.get(i);
            bb.position(start + this.elementHeadOffsets[i]);
            if (((ABIType)t).dynamic) {
                bb.position(start + IntType.UINT30.decode(bb, unitBuffer));
            }
            return ((ABIType)t).decode(bb, unitBuffer);
        }
        catch (IllegalArgumentException cause) {
            throw TupleType.exceptionWithIndex(true, i, cause);
        }
    }

    private J decodeIndices(ByteBuffer bb, int ... indices) {
        Object[] results = new Object[this.size()];
        int start = bb.position();
        byte[] unitBuffer = TupleType.newUnitBuffer();
        int prev = -1;
        for (int index : indices) {
            results[index] = this.decodeIndex(bb, start, unitBuffer, index);
            if (index <= prev) {
                throw new IllegalArgumentException("index out of order: " + index);
            }
            prev = index;
        }
        return Tuple.create(results);
    }

    static IllegalArgumentException exceptionWithIndex(boolean tuple, int i, IllegalArgumentException cause) {
        return new IllegalArgumentException((tuple ? "tuple index " : "array index ") + i + ": " + cause.getMessage(), cause);
    }

    @Override
    public Iterator<ABIType<?>> iterator() {
        return Arrays.asList(this.elementTypes).iterator();
    }

    public TupleType<J> select(boolean ... manifest) {
        return this.selectElements(manifest, false);
    }

    public TupleType<J> exclude(boolean ... manifest) {
        return this.selectElements(manifest, true);
    }

    private TupleType<J> selectElements(boolean[] manifest, boolean negate) {
        int size = this.size();
        if (manifest.length != size) {
            throw new IllegalArgumentException("expected manifest length " + size + " but found length " + manifest.length);
        }
        int c = 0;
        for (boolean b : manifest) {
            if (!(negate ^ b)) continue;
            ++c;
        }
        if (c == 0) {
            return TupleType.empty(this.flags);
        }
        boolean dynamic = false;
        ABIType[] selected = new ABIType[c];
        String[] selectedNames = this.elementNames == null ? null : new String[c];
        String[] selectedInternalTypes = this.elementInternalTypes == null ? null : new String[c];
        StringBuilder canonicalType = TupleType.newTypeBuilder();
        c = 0;
        for (int i = 0; i < size; ++i) {
            if (!(negate ^ manifest[i])) continue;
            if (selectedNames != null) {
                selectedNames[c] = this.elementNames[i];
            }
            if (selectedInternalTypes != null) {
                selectedInternalTypes[c] = this.elementInternalTypes[i];
            }
            Object e = this.get(i);
            canonicalType.append(((ABIType)e).canonicalType).append(',');
            dynamic |= ((ABIType)e).dynamic;
            selected[c] = e;
            ++c;
        }
        canonicalType.setCharAt(canonicalType.length() - 1, ')');
        return new TupleType<J>(canonicalType.toString(), dynamic, selected, selectedNames, selectedInternalTypes, null, this.flags);
    }

    static StringBuilder newTypeBuilder() {
        return new StringBuilder(40).append('(');
    }

    public static <X extends Tuple> TupleType<X> parse(String rawTupleTypeString) {
        return (TupleType)TypeFactory.create(rawTupleTypeString);
    }

    public static <X extends Tuple> TupleType<X> parse(int flags, String rawTupleTypeString) {
        return (TupleType)TypeFactory.create(flags, rawTupleTypeString);
    }

    public static <X extends Tuple> TupleType<X> of(String ... typeStrings) {
        if (typeStrings.length == 0) {
            return EMPTY;
        }
        StringBuilder rawType = TupleType.newTypeBuilder();
        for (String t : typeStrings) {
            rawType.append(t).append(',');
        }
        rawType.setCharAt(rawType.length() - 1, ')');
        return TupleType.parse(rawType.toString());
    }

    public String annotate(byte[] abi) {
        return this.annotate((Tuple)this.decode(ByteBuffer.wrap(abi), TupleType.newUnitBuffer()));
    }

    public String annotate(Tuple tuple) {
        return this.annotate(tuple, new StringBuilder(512));
    }

    String annotate(Tuple tuple, StringBuilder sb) {
        if (tuple.elements.length != this.size()) {
            throw this.lengthMismatch(tuple);
        }
        if (this.size() > 0) {
            Object t;
            int row = 0;
            int i = 0;
            int last = this.size() - 1;
            int offset = this.headLengthSum;
            ByteBuffer rowBuf = ByteBuffer.allocate(32);
            while (true) {
                t = this.get(i);
                if (!((ABIType)t).dynamic) {
                    row = this.encodeTailAnnotated(sb, (ABIType<Object>)t, row, i, tuple.elements[i]);
                    if (i == last) {
                        break;
                    }
                } else {
                    TupleType.insertIntUnsigned(offset, rowBuf);
                    rowBuf.flip();
                    this.appendAnnotatedRow(sb, rowBuf, row++, i, " offset");
                    rowBuf.flip();
                    if (i == last) break;
                    offset += ((ABIType)t).dynamicByteLength((Object)tuple.elements[i]);
                }
                ++i;
            }
            i = 0;
            do {
                t = this.get(i);
                if (!((ABIType)t).dynamic) continue;
                row = this.encodeTailAnnotated(sb, (ABIType<Object>)t, row, i, tuple.elements[i]);
            } while (++i < this.size());
        }
        return sb.toString();
    }

    private int encodeTailAnnotated(StringBuilder sb, ABIType<Object> t, int row, int i, Object v) {
        ByteBuffer encoding = ByteBuffer.allocate(t.validate(v));
        t.encodeTail(v, encoding);
        int len = encoding.position();
        if (len > 0) {
            encoding.flip();
            boolean dynamicArray = t instanceof ArrayType && -1 == t.asArrayType().getLength();
            this.appendAnnotatedRow(sb, encoding, row++, i, dynamicArray ? " length" : "");
            if (len > 32) {
                this.appendAnnotatedRow(sb, encoding, row++, i, dynamicArray ? "" : null);
                for (int n = 64; n < len; n += 32) {
                    this.appendAnnotatedRow(sb, encoding, row++, i, null);
                }
            }
        }
        return row;
    }

    private void appendAnnotatedRow(StringBuilder sb, ByteBuffer encoding, int row, int i, String note) {
        if (sb.length() > 0) {
            sb.append('\n');
        }
        sb.append(TupleType.hexLabel(row));
        byte[] rowBuffer = TupleType.newUnitBuffer();
        encoding.get(rowBuffer);
        sb.append(FastHex.encodeToString(rowBuffer));
        sb.append("\t[").append(i).append(']');
        if (note == null) {
            sb.append(" ...");
            return;
        }
        Object t = this.get(i);
        sb.append(' ').append(((ABIType)t).canonicalType);
        if (" offset".equals(note) || !((ABIType)t).dynamic) {
            String name = this.getElementName(i);
            if (name != null) {
                sb.append(" \"").append(name).append('\"');
            }
            sb.append(note);
            String internalType = this.getElementInternalType(i);
            if (internalType != null && !internalType.equals(((ABIType)t).canonicalType)) {
                sb.append(" \tinternal=").append(internalType);
            }
        } else {
            sb.append(note);
        }
    }

    static TupleType<Tuple> empty(int flags) {
        return flags == 0 ? EMPTY : (flags == 1 ? EMPTY_LEGACY : new TupleType("()", false, EMPTY_ARRAY, null, null, EMPTY_INDEX, flags));
    }
}

