/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.gossip.impl.gossip.shadowgraph;

import com.swirlds.base.time.Time;
import com.swirlds.config.api.Configuration;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.event.IntakeEventCounter;
import org.hiero.consensus.gossip.config.SyncConfig;
import org.hiero.consensus.gossip.impl.gossip.shadowgraph.ReservedEventWindow;
import org.hiero.consensus.gossip.impl.gossip.shadowgraph.ShadowEvent;
import org.hiero.consensus.gossip.impl.gossip.shadowgraph.Shadowgraph;
import org.hiero.consensus.gossip.impl.gossip.shadowgraph.SyncUtils;
import org.hiero.consensus.gossip.impl.gossip.sync.SyncMetrics;
import org.hiero.consensus.model.event.LinkedEvent;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.gossip.SyncProgress;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.node.NodeId;

public class ShadowgraphSynchronizer {
    private final Shadowgraph shadowGraph;
    protected final SyncMetrics syncMetrics;
    protected final Time time;
    private final boolean filterLikelyDuplicates;
    private final Duration nonAncestorFilterThreshold;
    private final Duration ancestorFilterThreshold;
    private final Duration selfFilterThreshold;
    protected final int maximumEventsPerSync;
    private final Consumer<SyncProgress> syncProgressHandler;

    public ShadowgraphSynchronizer(@NonNull Configuration configuration, @NonNull Metrics metrics, @NonNull Time time, int numberOfNodes, @NonNull SyncMetrics syncMetrics, @NonNull IntakeEventCounter intakeEventCounter, @NonNull Consumer<SyncProgress> syncLagHandler) {
        this.time = Objects.requireNonNull(time);
        this.shadowGraph = new Shadowgraph(metrics, numberOfNodes, intakeEventCounter);
        this.syncMetrics = Objects.requireNonNull(syncMetrics);
        SyncConfig syncConfig = (SyncConfig)configuration.getConfigData(SyncConfig.class);
        this.nonAncestorFilterThreshold = syncConfig.nonAncestorFilterThreshold();
        this.ancestorFilterThreshold = syncConfig.ancestorFilterThreshold();
        this.selfFilterThreshold = syncConfig.selfFilterThreshold();
        this.filterLikelyDuplicates = syncConfig.filterLikelyDuplicates();
        this.maximumEventsPerSync = syncConfig.maxSyncEventCount();
        this.syncProgressHandler = syncLagHandler;
    }

    @NonNull
    protected List<ShadowEvent> getTips() {
        List<ShadowEvent> myTips = this.shadowGraph.getTips();
        this.syncMetrics.updateTipsPerSync(myTips.size());
        this.syncMetrics.updateMultiTipsPerSync(SyncUtils.computeMultiTipCount(myTips));
        return myTips;
    }

    protected void reportSyncStatus(@NonNull EventWindow self, @NonNull EventWindow other, @NonNull NodeId nodeId) {
        this.syncProgressHandler.accept(new SyncProgress(nodeId, self, other));
    }

    @NonNull
    protected List<PlatformEvent> createSendList(@NonNull NodeId selfId, @NonNull Set<ShadowEvent> knownSet, @NonNull EventWindow myEventWindow, @NonNull EventWindow theirEventWindow, boolean broadcastRunning) {
        List<PlatformEvent> sendList;
        Objects.requireNonNull(selfId);
        Objects.requireNonNull(knownSet);
        Objects.requireNonNull(myEventWindow);
        Objects.requireNonNull(theirEventWindow);
        Set<ShadowEvent> knownAncestors = this.shadowGraph.findAncestors(knownSet, SyncUtils.unknownNonAncient(knownSet, myEventWindow, theirEventWindow));
        knownAncestors.addAll(knownSet);
        this.syncMetrics.knownSetSize(knownAncestors.size());
        Predicate<ShadowEvent> knownAncestorsPredicate = SyncUtils.unknownNonAncient(knownAncestors, myEventWindow, theirEventWindow);
        List<ShadowEvent> myNewTips = this.shadowGraph.getTips();
        List<ShadowEvent> unknownTips = myNewTips.stream().filter(knownAncestorsPredicate).collect(Collectors.toList());
        Set<ShadowEvent> sendSet = this.shadowGraph.findAncestors(unknownTips, knownAncestorsPredicate);
        sendSet.addAll(unknownTips);
        List<PlatformEvent> eventsTheyMayNeed = sendSet.stream().map(LinkedEvent::getPlatformEvent).collect(Collectors.toCollection(ArrayList::new));
        SyncUtils.sort(eventsTheyMayNeed);
        if (this.filterLikelyDuplicates) {
            long startFilterTime = this.time.nanoTime();
            sendList = SyncUtils.filterLikelyDuplicates(selfId, this.nonAncestorFilterThreshold, broadcastRunning ? this.ancestorFilterThreshold : Duration.ZERO, broadcastRunning ? this.selfFilterThreshold : Duration.ZERO, this.time.now(), eventsTheyMayNeed);
            long endFilterTime = this.time.nanoTime();
            this.syncMetrics.recordSyncFilterTime(endFilterTime - startFilterTime);
        } else {
            sendList = eventsTheyMayNeed;
        }
        if (this.maximumEventsPerSync > 0 && sendList.size() > this.maximumEventsPerSync) {
            sendList = sendList.subList(0, this.maximumEventsPerSync);
        }
        return sendList;
    }

    public void clear() {
        this.shadowGraph.clear();
    }

    public void addEvent(@NonNull PlatformEvent platformEvent) {
        this.shadowGraph.addEvent(platformEvent);
    }

    public void updateEventWindow(@NonNull EventWindow eventWindow) {
        this.shadowGraph.updateEventWindow(eventWindow);
    }

    public void start() {
    }

    public void stop() {
    }

    public ReservedEventWindow reserveEventWindow() {
        return this.shadowGraph.reserve();
    }

    public List<ShadowEvent> shadows(List<Hash> tips) {
        return this.shadowGraph.shadows(tips);
    }
}

