/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.metrics;

import com.swirlds.metrics.api.Counter;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Singleton;

@Singleton
public class TransactionThrottledByOpsDurationMetric {
    private static final Counter.Config CONFIG = new Counter.Config("app", String.format("%s:OpsDuration_TxnsThrottled", "SmartContractService")).withDescription("Count of transactions throttled by ops duration limit");
    private final Counter metrics;

    public TransactionThrottledByOpsDurationMetric(@NonNull Metrics metrics) {
        Objects.requireNonNull(metrics);
        this.metrics = (Counter)metrics.getOrCreate((MetricConfig)CONFIG);
    }

    public void increment() {
        this.metrics.increment();
    }

    public long getCount() {
        return this.metrics.get();
    }
}

