/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.grantapproval;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.gas.DispatchType;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.DispatchForResponseCodeHtsCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.grantapproval.ClassicGrantApprovalCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.grantapproval.ERCGrantApprovalCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.grantapproval.GrantApprovalDecoder;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class GrantApprovalTranslator
extends AbstractCallTranslator<HtsCallAttempt> {
    public static final SystemContractMethod ERC_GRANT_APPROVAL = SystemContractMethod.declare("approve(address,uint256)", "(bool)").withVia(SystemContractMethod.CallVia.PROXY).withVariant(SystemContractMethod.Variant.FT).withCategories(SystemContractMethod.Category.ERC20, SystemContractMethod.Category.APPROVAL);
    public static final SystemContractMethod ERC_GRANT_APPROVAL_NFT = SystemContractMethod.declare("approve(address,uint256)").withVia(SystemContractMethod.CallVia.PROXY).withVariant(SystemContractMethod.Variant.NFT).withCategories(SystemContractMethod.Category.ERC721, SystemContractMethod.Category.APPROVAL);
    public static final SystemContractMethod GRANT_APPROVAL = SystemContractMethod.declare("approve(address,address,uint256)", "(int32,bool)").withVariant(SystemContractMethod.Variant.FT).withCategories(SystemContractMethod.Category.ERC20, SystemContractMethod.Category.APPROVAL);
    public static final SystemContractMethod GRANT_APPROVAL_NFT = SystemContractMethod.declare("approveNFT(address,address,uint256)", "(int64)").withVariant(SystemContractMethod.Variant.NFT).withCategories(SystemContractMethod.Category.ERC721, SystemContractMethod.Category.APPROVAL);
    private final GrantApprovalDecoder decoder;

    @Inject
    public GrantApprovalTranslator(@NonNull GrantApprovalDecoder decoder, @NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HTS, systemContractMethodRegistry, contractMetrics);
        this.decoder = decoder;
        this.registerMethods(ERC_GRANT_APPROVAL, ERC_GRANT_APPROVAL_NFT, GRANT_APPROVAL, GRANT_APPROVAL_NFT);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HtsCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        return attempt.isMethod(GRANT_APPROVAL, GRANT_APPROVAL_NFT, ERC_GRANT_APPROVAL);
    }

    @Override
    public Call callFrom(@NonNull HtsCallAttempt attempt) {
        if (attempt.isSelector(ERC_GRANT_APPROVAL)) {
            return this.bodyForErc(attempt);
        }
        if (attempt.isSelector(GRANT_APPROVAL, GRANT_APPROVAL_NFT)) {
            return this.bodyForClassicCall(attempt);
        }
        return new DispatchForResponseCodeHtsCall(attempt, this.bodyForClassic(attempt), GrantApprovalTranslator::gasRequirement);
    }

    public static long gasRequirement(@NonNull TransactionBody body, @NonNull SystemContractGasCalculator systemContractGasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull AccountID payerId) {
        return systemContractGasCalculator.gasRequirement(body, DispatchType.APPROVE, payerId);
    }

    private TransactionBody bodyForClassic(HtsCallAttempt attempt) {
        if (attempt.isSelector(GRANT_APPROVAL)) {
            return this.decoder.decodeGrantApproval(attempt);
        }
        return this.decoder.decodeGrantApprovalNFT(attempt);
    }

    private ClassicGrantApprovalCall bodyForClassicCall(HtsCallAttempt attempt) {
        boolean isFungibleCall = attempt.isSelector(GRANT_APPROVAL);
        TokenType tokenType = isFungibleCall ? TokenType.FUNGIBLE_COMMON : TokenType.NON_FUNGIBLE_UNIQUE;
        Tuple call = isFungibleCall ? GRANT_APPROVAL.decodeCall(attempt.inputBytes()) : GRANT_APPROVAL_NFT.decodeCall(attempt.inputBytes());
        Object tokenAddress = call.get(0);
        AccountID spender = attempt.addressIdConverter().convert((Address)call.get(1));
        long amount = this.exactLongFrom((BigInteger)call.get(2));
        return new ClassicGrantApprovalCall(attempt.systemContractGasCalculator(), attempt.enhancement(), attempt.defaultVerificationStrategy(), attempt.senderId(), ConversionUtils.asTokenId(attempt.enhancement().nativeOperations().entityIdFactory(), (Address)tokenAddress), spender, amount, tokenType);
    }

    private ERCGrantApprovalCall bodyForErc(HtsCallAttempt attempt) {
        Tuple call = ERC_GRANT_APPROVAL.decodeCall(attempt.inputBytes());
        AccountID spenderId = attempt.addressIdConverter().convert((Address)call.get(0));
        long amount = this.exactLongFrom((BigInteger)call.get(1));
        return new ERCGrantApprovalCall(attempt.enhancement(), attempt.systemContractGasCalculator(), attempt.defaultVerificationStrategy(), attempt.senderId(), Objects.requireNonNull(attempt.redirectTokenId()), spenderId, amount, Objects.requireNonNull(attempt.redirectTokenType()));
    }

    private long exactLongFrom(@NonNull BigInteger value) {
        Objects.requireNonNull(value);
        return value.longValueExact();
    }
}

