/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.gascalculator;

import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.HomesteadGasCalculator;
import org.hyperledger.besu.evm.internal.Words;

public class TangerineWhistleGasCalculator
extends HomesteadGasCalculator {
    private static final long BALANCE_OPERATION_GAS_COST = 400L;
    private static final long CALL_OPERATION_BASE_GAS_COST = 700L;
    private static final long EXT_CODE_BASE_GAS_COST = 700L;
    private static final long SELFDESTRUCT_OPERATION_GAS_COST = 5000L;
    private static final long SELFDESTRUCT_OPERATION_CREATES_NEW_ACCOUNT = 30000L;
    private static final long SLOAD_OPERATION_GAS_COST = 200L;

    @Override
    public long getBalanceOperationGasCost() {
        return 400L;
    }

    private static long allButOneSixtyFourth(long value) {
        return value - value / 64L;
    }

    @Override
    public long callOperationBaseGasCost() {
        return 700L;
    }

    @Override
    public long callOperationGasCost(MessageFrame frame, long stipend, long inputDataOffset, long inputDataLength, long outputDataOffset, long outputDataLength, Wei transferValue, Account recipient, Address to, boolean accountIsWarm) {
        long inputDataMemoryExpansionCost = this.memoryExpansionGasCost(frame, inputDataOffset, inputDataLength);
        long outputDataMemoryExpansionCost = this.memoryExpansionGasCost(frame, outputDataOffset, outputDataLength);
        long memoryExpansionCost = Math.max(inputDataMemoryExpansionCost, outputDataMemoryExpansionCost);
        long cost = Words.clampedAdd(this.callOperationBaseGasCost(), memoryExpansionCost);
        if (!transferValue.isZero()) {
            cost = Words.clampedAdd(cost, this.callValueTransferGasCost());
        }
        if (recipient == null) {
            cost = Words.clampedAdd(cost, this.newAccountGasCost());
        }
        return cost;
    }

    private static long gasCap(long remaining, long stipend) {
        return Words.unsignedMin(TangerineWhistleGasCalculator.allButOneSixtyFourth(remaining), stipend);
    }

    @Override
    public long gasAvailableForChildCall(MessageFrame frame, long stipend, boolean transfersValue) {
        long gasCap = TangerineWhistleGasCalculator.gasCap(frame.getRemainingGas(), stipend);
        frame.decrementRemainingGas(gasCap);
        if (transfersValue) {
            return gasCap + this.getAdditionalCallStipend();
        }
        return gasCap;
    }

    @Override
    public long gasAvailableForChildCreate(long stipend) {
        return TangerineWhistleGasCalculator.allButOneSixtyFourth(stipend);
    }

    @Override
    protected long extCodeBaseGasCost() {
        return 700L;
    }

    @Override
    public long selfDestructOperationGasCost(Account recipient, Wei inheritance) {
        if (recipient == null) {
            return 30000L;
        }
        return 5000L;
    }

    @Override
    public long getSloadOperationGasCost() {
        return 200L;
    }
}

