/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class LtOperation
extends AbstractFixedCostOperation {
    static final Operation.OperationResult ltSuccess = new Operation.OperationResult(3L, null);

    public LtOperation(GasCalculator gasCalculator) {
        super(16, "LT", 2, 1, gasCalculator, gasCalculator.getVeryLowTierGasCost());
    }

    @Override
    public Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        return LtOperation.staticOperation(frame);
    }

    public static Operation.OperationResult staticOperation(MessageFrame frame) {
        Bytes value1;
        Bytes value0 = frame.popStackItem().trimLeadingZeros();
        Bytes result = value0.compareTo(value1 = frame.popStackItem().trimLeadingZeros()) < 0 ? BYTES_ONE : Bytes.EMPTY;
        frame.pushStackItem(result);
        return ltSuccess;
    }
}

