/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal;

import com.swirlds.virtualmap.internal.Path;
import java.util.BitSet;
import java.util.concurrent.ConcurrentHashMap;

public final class ConcurrentNodeStatusTracker {
    private static final int LIMIT = 0x40000000;
    private static final int RIGHT_SHIFTS_FOR_LIMIT_AS_DIVISOR = 30;
    private static final int DIVISOR = 0x3FFFFFFF;
    private final ConcurrentHashMap<Long, BitSetGroup> statusBitSets;
    private final long capacity;

    public ConcurrentNodeStatusTracker(long capacity) {
        this.capacity = capacity;
        this.statusBitSets = new ConcurrentHashMap();
        this.setNodeStatus(0L, 0, Status.NOT_KNOWN);
    }

    public void set(long value, Status status) {
        if (value <= 0L || value >= this.capacity) {
            throw new IllegalArgumentException(String.format("Value can only be between [0, %d), %d is illegal", this.capacity, value));
        }
        if (status == Status.UNKNOWN) {
            throw new IllegalArgumentException("Status can only be set to KNOWN or NOT_KNOWN");
        }
        int index = ConcurrentNodeStatusTracker.getIndexInBitSetFor(value);
        long bitSetIndex = ConcurrentNodeStatusTracker.getBitSetIndexFor(value);
        this.setNodeStatus(bitSetIndex, index, status);
    }

    public Status getStatus(long value) {
        Status status;
        if (value < 0L || value >= this.capacity) {
            throw new IllegalArgumentException(String.format("Value can only be between [0, %d), %d is illegal", this.capacity, value));
        }
        do {
            int index = ConcurrentNodeStatusTracker.getIndexInBitSetFor(value);
            long bitSetIndex = ConcurrentNodeStatusTracker.getBitSetIndexFor(value);
            status = this.statusBitSets.computeIfAbsent(bitSetIndex, k -> new BitSetGroup()).getStatus(index);
            value = Path.getParentPath(value);
        } while (status == Status.UNKNOWN);
        return status;
    }

    public Status getReportedStatus(long value) {
        if (value < 0L || value >= this.capacity) {
            throw new IllegalArgumentException(String.format("Value can only be between [0, %d), %d is illegal", this.capacity, value));
        }
        int index = ConcurrentNodeStatusTracker.getIndexInBitSetFor(value);
        long bitSetIndex = ConcurrentNodeStatusTracker.getBitSetIndexFor(value);
        return this.statusBitSets.computeIfAbsent(bitSetIndex, k -> new BitSetGroup()).getStatus(index);
    }

    private void setNodeStatus(long bitsetIndex, int valueIndex, Status status) {
        this.statusBitSets.compute(bitsetIndex, (k, bitsetGroup) -> {
            if (bitsetGroup == null) {
                bitsetGroup = new BitSetGroup();
            }
            bitsetGroup.setStatus(valueIndex, status);
            return bitsetGroup;
        });
    }

    private static long getBitSetIndexFor(long value) {
        return value >> 30;
    }

    private static int getIndexInBitSetFor(long value) {
        return (int)(value & 0x3FFFFFFFL);
    }

    public static enum Status {
        UNKNOWN,
        KNOWN,
        NOT_KNOWN;

    }

    private static final class BitSetGroup {
        private final BitSet status = new BitSet(0x40000000);
        private final BitSet knowns = new BitSet(0x40000000);

        private BitSetGroup() {
        }

        private void setStatus(int index, Status status) {
            this.knowns.set(index);
            if (status == Status.KNOWN) {
                this.status.set(index);
            }
        }

        private Status getStatus(int index) {
            if (!this.knowns.get(index)) {
                return Status.UNKNOWN;
            }
            return this.status.get(index) ? Status.KNOWN : Status.NOT_KNOWN;
        }
    }
}

