/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.gascalculator;

import java.math.BigInteger;
import java.util.function.Supplier;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.IstanbulGasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.precompile.BigIntegerModularExponentiationPrecompiledContract;

public class BerlinGasCalculator
extends IstanbulGasCalculator {
    private static final long COLD_SLOAD_COST = 2100L;
    private static final long COLD_ACCOUNT_ACCESS_COST = 2600L;
    protected static final long WARM_STORAGE_READ_COST = 100L;
    private static final long ACCESS_LIST_ADDRESS_COST = 2400L;
    protected static final long ACCESS_LIST_STORAGE_COST = 1900L;
    private static final long SLOAD_GAS = 100L;
    protected static final long SSTORE_RESET_GAS = 2900L;
    private static final long SSTORE_SET_GAS = 20000L;
    private static final long SSTORE_CLEARS_SCHEDULE = 15000L;
    protected static final long SSTORE_SET_GAS_LESS_SLOAD_GAS = 19900L;
    protected static final long SSTORE_RESET_GAS_LESS_SLOAD_GAS = 2800L;
    private static final long NEGATIVE_SSTORE_CLEARS_SCHEDULE = -15000L;
    private static final long COPY_WORD_GAS_COST = 3L;
    private final int maxPrecompile;

    protected BerlinGasCalculator(int maxPrecompile) {
        this.maxPrecompile = maxPrecompile;
    }

    public BerlinGasCalculator() {
        this(Address.BLAKE2B_F_COMPRESSION.toArrayUnsafe()[19]);
    }

    @Override
    public long accessListGasCost(int addresses, int storageSlots) {
        return 2400L * (long)addresses + 1900L * (long)storageSlots;
    }

    @Override
    public boolean isPrecompile(Address address) {
        byte[] addressBytes = address.toArrayUnsafe();
        for (int i = 0; i < 19; ++i) {
            if (addressBytes[i] == 0) continue;
            return false;
        }
        int lastByte = Byte.toUnsignedInt(addressBytes[19]);
        return lastByte <= this.maxPrecompile && lastByte != 0;
    }

    @Override
    public long getColdSloadCost() {
        return 2100L;
    }

    @Override
    public long getColdAccountAccessCost() {
        return 2600L;
    }

    @Override
    public long getWarmStorageReadCost() {
        return 100L;
    }

    @Override
    public long getBalanceOperationGasCost() {
        return 0L;
    }

    @Override
    public long callOperationBaseGasCost() {
        return 0L;
    }

    @Override
    public long extCodeHashOperationGasCost() {
        return 0L;
    }

    @Override
    public long getExtCodeSizeOperationGasCost() {
        return 0L;
    }

    @Override
    public long getSloadOperationGasCost() {
        return 0L;
    }

    @Override
    public long callOperationGasCost(MessageFrame frame, long stipend, long inputDataOffset, long inputDataLength, long outputDataOffset, long outputDataLength, Wei transferValue, Account recipient, Address to) {
        return this.callOperationGasCost(frame, stipend, inputDataOffset, inputDataLength, outputDataOffset, outputDataLength, transferValue, recipient, to, frame.warmUpAddress(to) || this.isPrecompile(to));
    }

    @Override
    public long callOperationGasCost(MessageFrame frame, long stipend, long inputDataOffset, long inputDataLength, long outputDataOffset, long outputDataLength, Wei transferValue, Account recipient, Address to, boolean accountIsWarm) {
        long baseCost = super.callOperationGasCost(frame, stipend, inputDataOffset, inputDataLength, outputDataOffset, outputDataLength, transferValue, recipient, to, true);
        return Words.clampedAdd(baseCost, accountIsWarm ? this.getWarmStorageReadCost() : this.getColdAccountAccessCost());
    }

    @Override
    public long extCodeCopyOperationGasCost(MessageFrame frame, long offset, long length) {
        return this.copyWordsToMemoryGasCost(frame, 0L, 3L, offset, length);
    }

    @Override
    public long calculateStorageCost(UInt256 newValue, Supplier<UInt256> currentValue, Supplier<UInt256> originalValue) {
        UInt256 localCurrentValue = currentValue.get();
        if (localCurrentValue.equals((Object)newValue)) {
            return 100L;
        }
        UInt256 localOriginalValue = originalValue.get();
        if (localOriginalValue.equals((Object)localCurrentValue)) {
            return localOriginalValue.isZero() ? 20000L : 2900L;
        }
        return 100L;
    }

    @Override
    public long calculateStorageRefundAmount(UInt256 newValue, Supplier<UInt256> currentValue, Supplier<UInt256> originalValue) {
        UInt256 localCurrentValue = currentValue.get();
        if (localCurrentValue.equals((Object)newValue)) {
            return 0L;
        }
        UInt256 localOriginalValue = originalValue.get();
        if (localOriginalValue.equals((Object)localCurrentValue)) {
            if (localOriginalValue.isZero()) {
                return 0L;
            }
            if (newValue.isZero()) {
                return 15000L;
            }
            return 0L;
        }
        long refund = 0L;
        if (!localOriginalValue.isZero()) {
            if (localCurrentValue.isZero()) {
                refund = -15000L;
            } else if (newValue.isZero()) {
                refund = 15000L;
            }
        }
        if (localOriginalValue.equals((Object)newValue)) {
            refund += localOriginalValue.isZero() ? 19900L : 2800L;
        }
        return refund;
    }

    @Override
    public long modExpGasCost(Bytes input) {
        long maxExponentLength;
        long baseLength = BigIntegerModularExponentiationPrecompiledContract.baseLength(input);
        long exponentLength = BigIntegerModularExponentiationPrecompiledContract.exponentLength(input);
        long modulusLength = BigIntegerModularExponentiationPrecompiledContract.modulusLength(input);
        long exponentOffset = Words.clampedAdd(96L, baseLength);
        long multiplicationComplexity = (Math.max(modulusLength, baseLength) + 7L) / 8L;
        if ((multiplicationComplexity = Words.clampedMultiply(multiplicationComplexity, multiplicationComplexity)) == 0L) {
            return 200L;
        }
        if (multiplicationComplexity > 0L && exponentLength > (maxExponentLength = Long.MAX_VALUE / multiplicationComplexity * 3L / 8L)) {
            return Long.MAX_VALUE;
        }
        long firstExponentBytesCap = Math.min(exponentLength, 32L);
        BigInteger firstExpBytes = BigIntegerModularExponentiationPrecompiledContract.extractParameter(input, Words.clampedToInt(exponentOffset), Words.clampedToInt(firstExponentBytesCap));
        long adjustedExponentLength = BerlinGasCalculator.adjustedExponentLength(exponentLength, firstExpBytes);
        long gasRequirement = Words.clampedMultiply(multiplicationComplexity, Math.max(adjustedExponentLength, 1L));
        if (gasRequirement != Long.MAX_VALUE) {
            gasRequirement /= 3L;
        }
        return Math.max(gasRequirement, 200L);
    }
}

