/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.InvalidOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class RelativeJumpIfOperation
extends AbstractFixedCostOperation {
    public static final int OPCODE = 225;

    public RelativeJumpIfOperation(GasCalculator gasCalculator) {
        super(225, "RJUMPI", 0, 0, gasCalculator, 4L);
    }

    @Override
    protected Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        Code code = frame.getCode();
        if (code.getEofVersion() == 0) {
            return InvalidOperation.INVALID_RESULT;
        }
        Bytes condition = frame.popStackItem();
        if (!condition.isZero()) {
            int pcPostInstruction = frame.getPC() + 1;
            return new Operation.OperationResult(this.gasCost, null, 2 + code.readBigEndianI16(pcPostInstruction) + 1);
        }
        return new Operation.OperationResult(this.gasCost, null, 3);
    }
}

