/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class XorOperation
extends AbstractFixedCostOperation {
    static final Operation.OperationResult xorSuccess = new Operation.OperationResult(3L, null);

    public XorOperation(GasCalculator gasCalculator) {
        super(24, "XOR", 2, 1, gasCalculator, gasCalculator.getVeryLowTierGasCost());
    }

    @Override
    public Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        return XorOperation.staticOperation(frame);
    }

    public static Operation.OperationResult staticOperation(MessageFrame frame) {
        Bytes value0 = frame.popStackItem();
        Bytes value1 = frame.popStackItem();
        Bytes result = value0.xor(value1);
        frame.pushStackItem(result);
        return xorSuccess;
    }
}

