/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.grpc.impl.netty;

import com.hedera.node.app.grpc.impl.MethodBase;
import com.hedera.node.app.grpc.impl.QueryMethod;
import com.hedera.node.app.grpc.impl.TransactionMethod;
import com.hedera.node.app.grpc.impl.netty.DataBufferMarshaller;
import com.hedera.node.app.workflows.ingest.IngestWorkflow;
import com.hedera.node.app.workflows.query.QueryWorkflow;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.node.config.data.JumboTransactionsConfig;
import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class GrpcServiceBuilder {
    private static final Logger logger = LogManager.getLogger(GrpcServiceBuilder.class);
    private final DataBufferMarshaller marshaller;
    private final DataBufferMarshaller jumboMarshaller;
    private final String serviceName;
    private final IngestWorkflow ingestWorkflow;
    private final QueryWorkflow queryWorkflow;
    private final Set<String> txMethodNames = new HashSet<String>();
    private final Set<String> queryMethodNames = new HashSet<String>();

    public GrpcServiceBuilder(@NonNull String serviceName, @NonNull IngestWorkflow ingestWorkflow, @NonNull QueryWorkflow queryWorkflow, @NonNull DataBufferMarshaller marshaller, @NonNull DataBufferMarshaller jumboMarshaller) {
        this.ingestWorkflow = Objects.requireNonNull(ingestWorkflow);
        this.queryWorkflow = Objects.requireNonNull(queryWorkflow);
        this.serviceName = Objects.requireNonNull(serviceName);
        if (serviceName.isBlank()) {
            throw new IllegalArgumentException("serviceName cannot be blank");
        }
        this.marshaller = Objects.requireNonNull(marshaller);
        this.jumboMarshaller = Objects.requireNonNull(jumboMarshaller);
    }

    @NonNull
    public GrpcServiceBuilder transaction(@NonNull String methodName) {
        if (Objects.requireNonNull(methodName).isBlank()) {
            throw new IllegalArgumentException("The gRPC method name cannot be blank");
        }
        this.txMethodNames.add(methodName);
        return this;
    }

    @NonNull
    public GrpcServiceBuilder query(@NonNull String methodName) {
        if (Objects.requireNonNull(methodName).isBlank()) {
            throw new IllegalArgumentException("The gRPC method name cannot be blank");
        }
        this.queryMethodNames.add(methodName);
        return this;
    }

    @NonNull
    public ServerServiceDefinition build(@NonNull Metrics metrics, ConfigProvider configProvider) {
        JumboTransactionsConfig jumboTxnConfig = (JumboTransactionsConfig)configProvider.getConfiguration().getConfigData(JumboTransactionsConfig.class);
        boolean jumboTxnIsEnabled = jumboTxnConfig.isEnabled();
        int jumboTxnMaxSize = jumboTxnConfig.maxTxnSize();
        int messageMaxSize = ((HederaConfig)configProvider.getConfiguration().getConfigData(HederaConfig.class)).transactionMaxBytes();
        ServerServiceDefinition.Builder builder = ServerServiceDefinition.builder((String)this.serviceName);
        this.txMethodNames.forEach(methodName -> {
            logger.debug("Registering gRPC transaction method {}.{}", (Object)this.serviceName, methodName);
            if (jumboTxnIsEnabled && jumboTxnConfig.grpcMethodNames().contains(methodName)) {
                TransactionMethod method = new TransactionMethod(this.serviceName, (String)methodName, this.ingestWorkflow, metrics, jumboTxnMaxSize);
                this.addMethod(builder, this.serviceName, (String)methodName, method, this.jumboMarshaller);
            } else {
                TransactionMethod method = new TransactionMethod(this.serviceName, (String)methodName, this.ingestWorkflow, metrics, messageMaxSize);
                this.addMethod(builder, this.serviceName, (String)methodName, method, this.marshaller);
            }
        });
        this.queryMethodNames.forEach(methodName -> {
            logger.debug("Registering gRPC query method {}.{}", (Object)this.serviceName, methodName);
            QueryMethod method = new QueryMethod(this.serviceName, (String)methodName, this.queryWorkflow, metrics, messageMaxSize);
            this.addMethod(builder, this.serviceName, (String)methodName, method, this.marshaller);
        });
        return builder.build();
    }

    private void addMethod(@NonNull ServerServiceDefinition.Builder builder, @NonNull String serviceName, @NonNull String methodName, @NonNull MethodBase method, @NonNull DataBufferMarshaller marshallerToUse) {
        Objects.requireNonNull(builder);
        Objects.requireNonNull(serviceName);
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(method);
        MethodDescriptor methodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(serviceName + "/" + methodName).setRequestMarshaller((MethodDescriptor.Marshaller)marshallerToUse).setResponseMarshaller((MethodDescriptor.Marshaller)marshallerToUse).build();
        builder.addMethod(ServerMethodDefinition.create((MethodDescriptor)methodDescriptor, (call, ignored) -> new ListenerImpl((ServerCall<BufferedData, BufferedData>)call, method)));
    }

    private static final class ListenerImpl
    extends ServerCall.Listener<BufferedData>
    implements StreamObserver<BufferedData> {
        private final ServerCall<BufferedData, BufferedData> call;
        private final MethodBase method;

        private ListenerImpl(@NonNull ServerCall<BufferedData, BufferedData> call, @NonNull MethodBase method) {
            Objects.requireNonNull(call);
            Objects.requireNonNull(method);
            this.call = call;
            this.method = method;
        }

        public void onReady() {
            if (this.call.isReady()) {
                this.call.request(1);
            }
        }

        public void onMessage(BufferedData requestBuffer) {
            this.method.invoke(requestBuffer, this);
        }

        public void onNext(BufferedData responseBuffer) {
            this.call.sendHeaders(new Metadata());
            this.call.sendMessage((Object)responseBuffer);
        }

        public void onError(Throwable t) {
            Status status = Status.UNKNOWN;
            if (t instanceof StatusRuntimeException) {
                StatusRuntimeException ex = (StatusRuntimeException)t;
                status = ex.getStatus();
            }
            this.call.close(status, new Metadata());
        }

        public void onCompleted() {
            this.call.close(Status.OK, new Metadata());
        }
    }
}

