/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers.transfer;

import com.esaulpaugh.headlong.abi.Function;
import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.EvmHookCall;
import com.hedera.hapi.node.base.HookCall;
import com.hedera.hapi.node.base.HookEntityId;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.hooks.HookExecution;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.service.token.AliasUtils;
import com.hedera.node.app.service.token.HookDispatchUtils;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.service.token.impl.handlers.BaseCryptoHandler;
import com.hedera.node.app.service.token.impl.handlers.BaseTokenHandler;
import com.hedera.node.app.service.token.impl.handlers.transfer.AdjustFungibleTokenChangesStep;
import com.hedera.node.app.service.token.impl.handlers.transfer.AdjustHbarChangesStep;
import com.hedera.node.app.service.token.impl.handlers.transfer.AssociateTokenRecipientsStep;
import com.hedera.node.app.service.token.impl.handlers.transfer.CustomFeeAssessmentStep;
import com.hedera.node.app.service.token.impl.handlers.transfer.EnsureAliasesStep;
import com.hedera.node.app.service.token.impl.handlers.transfer.NFTOwnersChangeStep;
import com.hedera.node.app.service.token.impl.handlers.transfer.ReplaceAliasesWithIDsInOp;
import com.hedera.node.app.service.token.impl.handlers.transfer.TransferContextImpl;
import com.hedera.node.app.service.token.impl.handlers.transfer.customfees.AssessedFeeWithPayerDebits;
import com.hedera.node.app.service.token.impl.handlers.transfer.hooks.HookCallFactory;
import com.hedera.node.app.service.token.impl.handlers.transfer.hooks.HookCalls;
import com.hedera.node.app.service.token.impl.handlers.transfer.hooks.HookContext;
import com.hedera.node.app.service.token.impl.handlers.transfer.hooks.HooksABI;
import com.hedera.node.app.service.token.impl.util.CryptoTransferValidationHelper;
import com.hedera.node.app.service.token.impl.validators.CryptoTransferValidator;
import com.hedera.node.app.service.token.records.CryptoTransferStreamBuilder;
import com.hedera.node.app.spi.validation.Validations;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TransferExecutor
extends BaseTokenHandler {
    private final CryptoTransferValidator validator;
    private final HookCallFactory hookCallFactory;

    @Inject
    public TransferExecutor(CryptoTransferValidator validator, HookCallFactory hookCallFactory) {
        this.validator = validator;
        this.hookCallFactory = hookCallFactory;
    }

    protected void preHandle(PreHandleContext context, CryptoTransferTransactionBody op) throws PreCheckException {
        this.preHandle(context, op, OptionalKeyCheck.RECEIVER_KEY_IS_REQUIRED);
    }

    private void preHandle(@NonNull PreHandleContext context, @NonNull CryptoTransferTransactionBody op, @NonNull OptionalKeyCheck receiverKeyCheck) throws PreCheckException {
        ReadableAccountStore accountStore = (ReadableAccountStore)context.createStore(ReadableAccountStore.class);
        ReadableTokenStore tokenStore = (ReadableTokenStore)context.createStore(ReadableTokenStore.class);
        List tokenTransfers = op.tokenTransfers();
        List hbarTransfers = op.transfersOrElse(TransferList.DEFAULT).accountAmounts();
        for (TokenTransferList transfers : tokenTransfers) {
            ReadableTokenStore.TokenMetadata tokenMeta = tokenStore.getTokenMeta(transfers.tokenOrElse(TokenID.DEFAULT));
            if (tokenMeta == null) {
                throw new PreCheckException(ResponseCodeEnum.INVALID_TOKEN_ID);
            }
            this.checkFungibleTokenTransfers(transfers.transfers(), context, accountStore, false, receiverKeyCheck);
            this.checkNftTransfers(transfers.nftTransfers(), context, tokenMeta, op, accountStore, receiverKeyCheck);
        }
        this.checkFungibleTokenTransfers(hbarTransfers, context, accountStore, true);
    }

    protected void preHandleWithOptionalReceiverSignature(PreHandleContext context, CryptoTransferTransactionBody op) throws PreCheckException {
        this.preHandle(context, op, OptionalKeyCheck.RECEIVER_KEY_IS_OPTIONAL);
    }

    protected void executeCryptoTransfer(TransactionBody txn, TransferContextImpl transferContext, HandleContext context, CryptoTransferStreamBuilder recordBuilder) {
        this.executeCryptoTransfer(txn, transferContext, context, recordBuilder, false);
    }

    protected void executeCryptoTransfer(TransactionBody txn, TransferContextImpl transferContext, HandleContext context, CryptoTransferStreamBuilder recordBuilder, boolean skipCustomFee) {
        AccountID topLevelPayer = context.payer();
        transferContext.validateHbarAllowances();
        CryptoTransferTransactionBody replacedOp = this.ensureAndReplaceAliasesInOp(txn, transferContext, context, this.validator);
        ArrayList<AssociateTokenRecipientsStep> steps = new ArrayList<AssociateTokenRecipientsStep>();
        steps.add(new AssociateTokenRecipientsStep(replacedOp));
        CustomFeeAssessmentStep customFeeStep = new CustomFeeAssessmentStep(replacedOp);
        List<CryptoTransferTransactionBody> txns = List.of(replacedOp);
        if (!skipCustomFee) {
            txns = customFeeStep.assessCustomFees(transferContext);
        }
        boolean hasHooks = CryptoTransferValidator.hasHooks(replacedOp);
        HookCalls hookCalls = null;
        if (hasHooks) {
            List<AssessedFeeWithPayerDebits> assessedFeesWithPayerDebits = transferContext.getAssessedFeesWithPayerDebits();
            hookCalls = this.hookCallFactory.from(transferContext.getHandleContext(), replacedOp, assessedFeesWithPayerDebits);
            this.dispatchHookCalls(hookCalls.context(), hookCalls.preOnlyHooks(), transferContext.getHandleContext(), HooksABI.FN_ALLOW);
            this.dispatchHookCalls(hookCalls.context(), hookCalls.prePostHooks(), transferContext.getHandleContext(), HooksABI.FN_ALLOW_PRE);
        }
        for (CryptoTransferTransactionBody t : txns) {
            new AssociateTokenRecipientsStep(t).doIn(transferContext);
            new AdjustHbarChangesStep(t, topLevelPayer).doIn(transferContext);
            new AdjustFungibleTokenChangesStep(t.tokenTransfers(), topLevelPayer).doIn(transferContext);
            new NFTOwnersChangeStep(t.tokenTransfers(), topLevelPayer).doIn(transferContext);
        }
        if (hasHooks) {
            this.dispatchHookCalls(hookCalls.context(), hookCalls.prePostHooks(), transferContext.getHandleContext(), HooksABI.FN_ALLOW_POST);
        }
        if (!transferContext.getAutomaticAssociations().isEmpty()) {
            transferContext.getAutomaticAssociations().forEach(arg_0 -> ((CryptoTransferStreamBuilder)recordBuilder).addAutomaticTokenAssociation(arg_0));
        }
        if (!transferContext.getAssessedCustomFees().isEmpty()) {
            recordBuilder.assessedCustomFees(transferContext.getAssessedCustomFees());
        }
    }

    protected void executeAirdropCryptoTransfer(@NonNull HandleContext context, @NonNull List<TokenTransferList> tokenTransferList, @NonNull CryptoTransferStreamBuilder recordBuilder) {
        CryptoTransferTransactionBody cryptoTransferBody = CryptoTransferTransactionBody.newBuilder().tokenTransfers(tokenTransferList).build();
        TransactionBody syntheticCryptoTransferTxn = TransactionBody.newBuilder().cryptoTransfer(cryptoTransferBody).build();
        TransferContextImpl transferContext = new TransferContextImpl(context, cryptoTransferBody, true);
        this.executeCryptoTransferWithoutCustomFee(syntheticCryptoTransferTxn, transferContext, context, recordBuilder);
    }

    protected CryptoTransferTransactionBody chargeCustomFeeForAirdrops(TransactionBody txn, TransferContextImpl transferContext) {
        CustomFeeAssessmentStep customFeeStep = new CustomFeeAssessmentStep(txn.cryptoTransferOrThrow());
        List<CryptoTransferTransactionBody> transferBodies = customFeeStep.assessCustomFees(transferContext);
        AccountID topLevelPayer = transferContext.getHandleContext().payer();
        int n = transferBodies.size();
        for (int i = 1; i < n; ++i) {
            AdjustHbarChangesStep adjustHbarChangesStep = new AdjustHbarChangesStep(transferBodies.get(i), topLevelPayer);
            adjustHbarChangesStep.doIn(transferContext);
            AdjustFungibleTokenChangesStep adjustFungibleChangesStep = new AdjustFungibleTokenChangesStep(transferBodies.get(i).tokenTransfers(), topLevelPayer);
            adjustFungibleChangesStep.doIn(transferContext);
        }
        return transferBodies.getFirst();
    }

    protected void executeCryptoTransferWithoutCustomFee(TransactionBody txn, TransferContextImpl transferContext, HandleContext context, CryptoTransferStreamBuilder recordBuilder) {
        this.executeCryptoTransfer(txn, transferContext, context, recordBuilder, true);
    }

    private CryptoTransferTransactionBody ensureAndReplaceAliasesInOp(@NonNull TransactionBody txn, @NonNull TransferContextImpl transferContext, @NonNull HandleContext context, @NonNull CryptoTransferValidator validator) throws HandleException {
        CryptoTransferTransactionBody op = txn.cryptoTransferOrThrow();
        this.ensureExistenceOfAliasesOrCreate(op, transferContext);
        CryptoTransferTransactionBody replacedOp = new ReplaceAliasesWithIDsInOp().replaceAliasesWithIds(op, transferContext);
        try {
            validator.pureChecks(replacedOp);
        }
        catch (PreCheckException e) {
            throw new HandleException(e.responseCode());
        }
        return replacedOp;
    }

    private void ensureExistenceOfAliasesOrCreate(@NonNull CryptoTransferTransactionBody op, @NonNull TransferContextImpl transferContext) {
        EnsureAliasesStep ensureAliasExistence = new EnsureAliasesStep(op);
        ensureAliasExistence.doIn(transferContext);
    }

    private void dispatchHookCalls(HookContext hookContext, List<HookCallFactory.HookInvocation> hookInvocations, HandleContext handleContext, Function function) {
        for (HookCallFactory.HookInvocation hookInvocation : hookInvocations) {
            HookExecution execution = HookExecution.newBuilder().hookEntityId(HookEntityId.newBuilder().accountId(hookInvocation.ownerId()).build()).call(HookCall.newBuilder().evmHookCall(EvmHookCall.newBuilder().gasLimit(hookInvocation.gasLimit()).data(Bytes.wrap((byte[])HooksABI.encode(hookInvocation, hookContext, function))).build()).hookId(hookInvocation.hookId()).build()).build();
            HookDispatchUtils.dispatchExecution((HandleContext)handleContext, (HookExecution)execution, (Function)function);
        }
    }

    private void checkFungibleTokenTransfers(@NonNull List<AccountAmount> transfers, @NonNull PreHandleContext ctx, @NonNull ReadableAccountStore accountStore, boolean hbarTransfer) throws PreCheckException {
        this.checkFungibleTokenTransfers(transfers, ctx, accountStore, hbarTransfer, OptionalKeyCheck.RECEIVER_KEY_IS_REQUIRED);
    }

    private void checkFungibleTokenTransfers(@NonNull List<AccountAmount> transfers, @NonNull PreHandleContext ctx, @NonNull ReadableAccountStore accountStore, boolean hbarTransfer, @NonNull OptionalKeyCheck receiverKeyCheck) throws PreCheckException {
        for (AccountAmount accountAmount : transfers) {
            boolean isDebit;
            AccountID accountId = Validations.validateAccountID((AccountID)accountAmount.accountIDOrElse(AccountID.DEFAULT), null);
            Account account = accountStore.getAliasedAccountById(accountId);
            boolean isCredit = accountAmount.amount() > 0L;
            boolean bl = isDebit = accountAmount.amount() < 0L;
            if (account != null) {
                boolean usesHook;
                if (BaseCryptoHandler.isStakingAccount(ctx.configuration(), account.accountId()) && (isDebit || isCredit && !hbarTransfer)) {
                    throw new PreCheckException(ResponseCodeEnum.INVALID_ACCOUNT_ID);
                }
                boolean bl2 = usesHook = accountAmount.hasPreTxAllowanceHook() || accountAmount.hasPrePostTxAllowanceHook();
                if (isDebit && !accountAmount.isApproval() && !usesHook) {
                    if (HapiUtils.isHollow((Account)account)) {
                        ctx.requireSignatureForHollowAccount(account);
                        continue;
                    }
                    ctx.requireKeyOrThrow(account.key(), ResponseCodeEnum.INVALID_ACCOUNT_ID);
                    continue;
                }
                if (!isCredit || !account.receiverSigRequired()) continue;
                if (receiverKeyCheck == OptionalKeyCheck.RECEIVER_KEY_IS_OPTIONAL || usesHook) {
                    ctx.optionalKey(account.keyOrThrow());
                    continue;
                }
                ctx.requireKeyOrThrow(account.key(), ResponseCodeEnum.INVALID_TRANSFER_ACCOUNT_ID);
                continue;
            }
            if (!(hbarTransfer ? !isCredit || !AliasUtils.isAlias((AccountID)accountId) : isDebit)) continue;
            throw new PreCheckException(ResponseCodeEnum.INVALID_ACCOUNT_ID);
        }
    }

    private void checkNftTransfers(List<NftTransfer> nftTransfersList, PreHandleContext meta, ReadableTokenStore.TokenMetadata tokenMeta, CryptoTransferTransactionBody op, ReadableAccountStore accountStore, OptionalKeyCheck receiverKeyCheck) throws PreCheckException {
        for (NftTransfer nftTransfer : nftTransfersList) {
            AccountID senderId = nftTransfer.senderAccountIDOrElse(AccountID.DEFAULT);
            Validations.validateAccountID((AccountID)senderId, null);
            CryptoTransferValidationHelper.checkSender(senderId, nftTransfer, meta, accountStore);
            AccountID receiverId = nftTransfer.receiverAccountIDOrElse(AccountID.DEFAULT);
            Validations.validateAccountID((AccountID)receiverId, null);
            CryptoTransferValidationHelper.checkReceiver(receiverId, senderId, nftTransfer, meta, tokenMeta, op, accountStore, receiverKeyCheck);
        }
    }

    public static enum OptionalKeyCheck {
        RECEIVER_KEY_IS_OPTIONAL,
        RECEIVER_KEY_IS_REQUIRED;

    }

    public record HookInvocations(List<HookCallFactory.HookInvocation> pre, List<HookCallFactory.HookInvocation> post) {
    }
}

