/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.metrics.api.Clock;
import io.helidon.metrics.api.Counter;
import io.helidon.metrics.api.DistributionStatisticsConfig;
import io.helidon.metrics.api.DistributionSummary;
import io.helidon.metrics.api.FunctionalCounter;
import io.helidon.metrics.api.Gauge;
import io.helidon.metrics.api.HistogramSnapshot;
import io.helidon.metrics.api.Meter;
import io.helidon.metrics.api.MeterRegistry;
import io.helidon.metrics.api.MetricsConfig;
import io.helidon.metrics.api.MetricsFactory;
import io.helidon.metrics.api.NoOpMeter;
import io.helidon.metrics.api.NoOpMeterRegistry;
import io.helidon.metrics.api.NoOpTag;
import io.helidon.metrics.api.Tag;
import io.helidon.metrics.api.Timer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;

class NoOpMetricsFactory
implements MetricsFactory {
    private static final Clock SYSTEM_CLOCK = new Clock(){

        @Override
        public <R> R unwrap(Class<? extends R> c) {
            return c.cast(this);
        }

        @Override
        public long wallTime() {
            return System.currentTimeMillis();
        }

        @Override
        public long monotonicTime() {
            return System.nanoTime();
        }
    };
    private final MeterRegistry meterRegistry = new NoOpMeterRegistry();
    private final MetricsConfig metricsConfig = MetricsConfig.create();

    NoOpMetricsFactory() {
    }

    static NoOpMetricsFactory create() {
        return new NoOpMetricsFactory();
    }

    @Override
    public void close() {
    }

    @Override
    public MeterRegistry globalRegistry() {
        return this.meterRegistry;
    }

    @Override
    public MeterRegistry globalRegistry(MetricsConfig metricsConfig) {
        return this.meterRegistry;
    }

    @Override
    public MeterRegistry globalRegistry(Consumer<Meter> onAddListener, Consumer<Meter> onRemoveListener, boolean backfill) {
        return this.meterRegistry;
    }

    @Override
    public MetricsConfig metricsConfig() {
        return this.metricsConfig;
    }

    public NoOpMeterRegistry.Builder meterRegistryBuilder() {
        return NoOpMeterRegistry.builder();
    }

    @Override
    public MeterRegistry createMeterRegistry(MetricsConfig metricsConfig) {
        return new NoOpMeterRegistry();
    }

    @Override
    public MeterRegistry createMeterRegistry(MetricsConfig metricsConfig, Consumer<Meter> onAddListener, Consumer<Meter> onRemoveListener) {
        return this.createMeterRegistry(metricsConfig).onMeterAdded(onAddListener).onMeterRemoved(onRemoveListener);
    }

    @Override
    public MeterRegistry createMeterRegistry(Clock clock, MetricsConfig metricsConfig) {
        return this.createMeterRegistry(metricsConfig);
    }

    @Override
    public MeterRegistry createMeterRegistry(Clock clock, MetricsConfig metricsConfig, Consumer<Meter> onAddListener, Consumer<Meter> onRemoveListener) {
        return this.createMeterRegistry(clock, metricsConfig).onMeterAdded(onAddListener).onMeterRemoved(onRemoveListener);
    }

    @Override
    public Clock clockSystem() {
        return SYSTEM_CLOCK;
    }

    @Override
    public Tag tagCreate(String key, String value) {
        return new NoOpTag(key, value);
    }

    @Override
    public Counter.Builder counterBuilder(String name) {
        return NoOpMeter.Counter.builder(name);
    }

    @Override
    public <T> FunctionalCounter.Builder<T> functionalCounterBuilder(String name, T stateObject, Function<T, Long> fn) {
        return NoOpMeter.FunctionalCounter.builder(name, stateObject, fn);
    }

    @Override
    public DistributionSummary.Builder distributionSummaryBuilder(String name, DistributionStatisticsConfig.Builder configBuilder) {
        return NoOpMeter.DistributionSummary.builder(name).distributionStatisticsConfig(configBuilder);
    }

    @Override
    public <T> Gauge.Builder<Double> gaugeBuilder(String name, T stateObject, ToDoubleFunction<T> fn) {
        return NoOpMeter.Gauge.builder(name, stateObject, fn);
    }

    @Override
    public <N extends Number> Gauge.Builder<N> gaugeBuilder(String name, Supplier<N> supplier) {
        return NoOpMeter.Gauge.builder(name, supplier);
    }

    @Override
    public Timer.Builder timerBuilder(String name) {
        return NoOpMeter.Timer.builder(name);
    }

    @Override
    public DistributionStatisticsConfig.Builder distributionStatisticsConfigBuilder() {
        return NoOpMeter.DistributionStatisticsConfig.builder();
    }

    @Override
    public HistogramSnapshot histogramSnapshotEmpty(long count, double total, double max) {
        return NoOpMeter.HistogramSnapshot.empty(count, total, max);
    }

    @Override
    public Timer.Sample timerStart() {
        return NoOpMeter.Timer.start();
    }

    @Override
    public Timer.Sample timerStart(MeterRegistry registry) {
        return NoOpMeter.Timer.start(registry);
    }

    @Override
    public Timer.Sample timerStart(Clock clock) {
        return NoOpMeter.Timer.start(clock);
    }
}

