/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.config.types;

import com.hedera.node.app.hapi.utils.sysfiles.domain.throttling.ScaleFactor;
import com.hedera.node.config.types.TriggeredValuesParser;
import java.util.Arrays;

public record UtilizationScaleFactors(int[] usagePercentTriggers, ScaleFactor[] scaleFactors) {
    public static UtilizationScaleFactors from(String csv) {
        TriggeredValuesParser.TriggeredValues<ScaleFactor> triggeredFactors = TriggeredValuesParser.parseFrom(csv, ScaleFactor::from);
        return new UtilizationScaleFactors(triggeredFactors.triggers().stream().mapToInt(v -> v).toArray(), (ScaleFactor[])triggeredFactors.values().stream().toArray(ScaleFactor[]::new));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UtilizationScaleFactors that = (UtilizationScaleFactors)o;
        return Arrays.equals(this.usagePercentTriggers, that.usagePercentTriggers) && Arrays.equals(this.scaleFactors, that.scaleFactors);
    }

    @Override
    public int hashCode() {
        int result = Arrays.hashCode(this.usagePercentTriggers);
        result = 31 * result + Arrays.hashCode(this.scaleFactors);
        return result;
    }

    @Override
    public String toString() {
        return "UtilizationScaleFactors{usagePercentTriggers=" + Arrays.toString(this.usagePercentTriggers) + ", scaleFactors=" + Arrays.toString(this.scaleFactors) + "}";
    }
}

