/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.precompile;

import com.google.common.annotations.VisibleForTesting;
import ethereum.ckzg4844.CKZG4844JNI;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.hyperledger.besu.crypto.Hash;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.precompile.PrecompiledContract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KZGPointEvalPrecompiledContract
implements PrecompiledContract {
    private static final AtomicBoolean loaded = new AtomicBoolean(false);
    private static final Logger LOG = LoggerFactory.getLogger(KZGPointEvalPrecompiledContract.class);
    private static Bytes successResult;

    private static void loadLib() {
        CKZG4844JNI.loadNativeLibrary();
        Bytes32 fieldElementsPerBlob = Bytes32.wrap((Bytes)Words.intBytes(4096).xor((Bytes)Bytes32.ZERO));
        Bytes32 blsModulus = Bytes32.wrap((Bytes)Bytes.of((byte[])CKZG4844JNI.BLS_MODULUS.toByteArray()).xor((Bytes)Bytes32.ZERO));
        successResult = Bytes.concatenate((Bytes[])new Bytes[]{fieldElementsPerBlob, blsModulus});
    }

    public static void init(Path trustedSetupFile) {
        if (!loaded.compareAndSet(false, true)) {
            throw new IllegalStateException("KZG trusted setup was already loaded");
        }
        KZGPointEvalPrecompiledContract.loadLib();
        String trustedSetupResourceName = trustedSetupFile.toAbsolutePath().toString();
        LOG.info("Loading trusted setup from user-specified resource {}", (Object)trustedSetupResourceName);
        CKZG4844JNI.loadTrustedSetup((String)trustedSetupResourceName);
    }

    public static void init() {
        if (loaded.compareAndSet(false, true)) {
            KZGPointEvalPrecompiledContract.loadLib();
            String trustedSetupResourceName = "/kzg-trusted-setups/mainnet.txt";
            LOG.info("Loading network trusted setup from classpath resource {}", (Object)"/kzg-trusted-setups/mainnet.txt");
            CKZG4844JNI.loadTrustedSetupFromResource((String)"/kzg-trusted-setups/mainnet.txt", KZGPointEvalPrecompiledContract.class);
        }
    }

    @VisibleForTesting
    public static void tearDown() {
        CKZG4844JNI.freeTrustedSetup();
        loaded.set(false);
    }

    @Override
    public String getName() {
        return "KZGPointEval";
    }

    @Override
    public long gasRequirement(Bytes input) {
        return 50000L;
    }

    @Override
    @Nonnull
    public PrecompiledContract.PrecompileContractResult computePrecompile(Bytes input, @Nonnull MessageFrame messageFrame) {
        if (input.size() != 192) {
            return PrecompiledContract.PrecompileContractResult.halt(null, Optional.of(ExceptionalHaltReason.PRECOMPILE_ERROR));
        }
        Bytes32 versionedHash = Bytes32.wrap((Bytes)input.slice(0, 32));
        Bytes z = input.slice(32, 32);
        Bytes y = input.slice(64, 32);
        Bytes commitment = input.slice(96, 48);
        Bytes proof = input.slice(144, 48);
        if (versionedHash.get(0) != 1) {
            return PrecompiledContract.PrecompileContractResult.halt(null, Optional.of(ExceptionalHaltReason.PRECOMPILE_ERROR));
        }
        byte[] hash = Hash.sha256((Bytes)commitment).toArrayUnsafe();
        hash[0] = 1;
        if (!versionedHash.equals((Object)Bytes32.wrap((byte[])hash))) {
            return PrecompiledContract.PrecompileContractResult.halt(null, Optional.of(ExceptionalHaltReason.PRECOMPILE_ERROR));
        }
        try {
            boolean proved = CKZG4844JNI.verifyKzgProof((byte[])commitment.toArray(), (byte[])z.toArray(), (byte[])y.toArray(), (byte[])proof.toArray());
            if (proved) {
                return PrecompiledContract.PrecompileContractResult.success(successResult);
            }
            return PrecompiledContract.PrecompileContractResult.halt(null, Optional.of(ExceptionalHaltReason.PRECOMPILE_ERROR));
        }
        catch (RuntimeException kzgFailed) {
            LOG.debug("Native KZG failed", (Throwable)kzgFailed);
            return PrecompiledContract.PrecompileContractResult.halt(null, Optional.of(ExceptionalHaltReason.PRECOMPILE_ERROR));
        }
    }
}

