/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.ModificationNotAllowedException;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.account.AccountState;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.tracing.OperationTracer;

public abstract class AbstractMessageProcessor {
    private final Collection<? super Address> forceDeleteAccountsWhenEmpty;
    final EVM evm;

    AbstractMessageProcessor(EVM evm, Collection<Address> forceDeleteAccountsWhenEmpty) {
        this.evm = evm;
        this.forceDeleteAccountsWhenEmpty = forceDeleteAccountsWhenEmpty;
    }

    protected abstract void start(MessageFrame var1, OperationTracer var2);

    protected abstract void codeSuccess(MessageFrame var1, OperationTracer var2);

    private void clearAccumulatedStateBesidesGasAndOutput(MessageFrame frame) {
        ArrayList addresses = frame.getWorldUpdater().getTouchedAccounts().stream().filter(AccountState::isEmpty).map(Account::getAddress).filter(this.forceDeleteAccountsWhenEmpty::contains).collect(Collectors.toCollection(ArrayList::new));
        frame.getWorldUpdater().revert();
        addresses.forEach(h -> frame.getWorldUpdater().deleteAccount((Address)h));
        frame.getWorldUpdater().commit();
        frame.clearLogs();
        frame.clearGasRefund();
        frame.rollback();
    }

    private void exceptionalHalt(MessageFrame frame) {
        this.clearAccumulatedStateBesidesGasAndOutput(frame);
        frame.clearGasRemaining();
        frame.clearOutputData();
        frame.setState(MessageFrame.State.COMPLETED_FAILED);
    }

    protected void revert(MessageFrame frame) {
        this.clearAccumulatedStateBesidesGasAndOutput(frame);
        frame.setState(MessageFrame.State.COMPLETED_FAILED);
    }

    private void completedSuccess(MessageFrame frame) {
        frame.getWorldUpdater().commit();
        frame.getMessageFrameStack().removeFirst();
        frame.notifyCompletion();
    }

    private void completedFailed(MessageFrame frame) {
        frame.getMessageFrameStack().removeFirst();
        frame.notifyCompletion();
    }

    private void codeExecute(MessageFrame frame, OperationTracer operationTracer) {
        try {
            this.evm.runToHalt(frame, operationTracer);
        }
        catch (ModificationNotAllowedException e) {
            frame.setState(MessageFrame.State.REVERT);
        }
    }

    public void process(MessageFrame frame, OperationTracer operationTracer) {
        if (operationTracer != null) {
            if (frame.getState() == MessageFrame.State.NOT_STARTED) {
                operationTracer.traceContextEnter(frame);
                this.start(frame, operationTracer);
            } else {
                operationTracer.traceContextReEnter(frame);
            }
        }
        if (frame.getState() == MessageFrame.State.CODE_EXECUTING) {
            this.codeExecute(frame, operationTracer);
            if (frame.getState() == MessageFrame.State.CODE_SUSPENDED) {
                return;
            }
            if (frame.getState() == MessageFrame.State.CODE_SUCCESS) {
                this.codeSuccess(frame, operationTracer);
            }
        }
        if (frame.getState() == MessageFrame.State.EXCEPTIONAL_HALT) {
            this.exceptionalHalt(frame);
        }
        if (frame.getState() == MessageFrame.State.REVERT) {
            this.revert(frame);
        }
        if (frame.getState() == MessageFrame.State.COMPLETED_SUCCESS) {
            if (operationTracer != null) {
                operationTracer.traceContextExit(frame);
            }
            this.completedSuccess(frame);
        }
        if (frame.getState() == MessageFrame.State.COMPLETED_FAILED) {
            if (operationTracer != null) {
                operationTracer.traceContextExit(frame);
            }
            this.completedFailed(frame);
        }
    }

    public Code getCodeFromEVM(@Nonnull Hash codeHash, Bytes codeBytes) {
        return this.evm.getCode(codeHash, codeBytes);
    }

    public Code getCodeFromEVMForCreation(Bytes codeBytes) {
        return this.evm.getCodeForCreation(codeBytes);
    }
}

