/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.standalone.impl;

import com.hedera.hapi.platform.state.PlatformState;
import com.hedera.node.app.metrics.StoreMetricsServiceImpl;
import com.hedera.node.app.spi.info.NetworkInfo;
import com.hedera.node.app.spi.metrics.StoreMetricsService;
import com.hedera.node.app.throttle.ThrottleAccumulator;
import com.hedera.node.app.throttle.ThrottleMetrics;
import com.hedera.node.app.throttle.annotations.BackendThrottle;
import com.hedera.node.app.workflows.standalone.impl.StandaloneNetworkInfo;
import com.hedera.node.config.ConfigProvider;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.state.PlatformStateAccessor;
import com.swirlds.platform.state.service.SnapshotPlatformStateAccessor;
import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.InstantSource;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.IntSupplier;
import javax.inject.Singleton;

@Module
public interface StandaloneModule {
    @Provides
    @Singleton
    @Nullable
    public static AtomicBoolean provideMaybeSystemEntitiesCreatedFlag() {
        return null;
    }

    @Binds
    @Singleton
    public NetworkInfo bindNetworkInfo(@NonNull StandaloneNetworkInfo var1);

    @Provides
    @Singleton
    public static IntSupplier provideFrontendThrottleSplit() {
        return () -> 1;
    }

    @Provides
    @Singleton
    @BackendThrottle
    public static ThrottleAccumulator provideBackendThrottleAccumulator(@NonNull ConfigProvider configProvider, boolean disableThrottling, @NonNull Metrics metrics) {
        ThrottleMetrics throttleMetrics = new ThrottleMetrics(metrics, ThrottleAccumulator.ThrottleType.BACKEND_THROTTLE);
        return new ThrottleAccumulator(() -> 1, () -> ((ConfigProvider)configProvider).getConfiguration(), disableThrottling ? ThrottleAccumulator.ThrottleType.NOOP_THROTTLE : ThrottleAccumulator.ThrottleType.BACKEND_THROTTLE, throttleMetrics, ThrottleAccumulator.Verbose.YES);
    }

    @Provides
    @Singleton
    public static PlatformStateAccessor providePlatformState() {
        return new SnapshotPlatformStateAccessor(PlatformState.DEFAULT);
    }

    @Provides
    @Singleton
    public static InstantSource provideInstantSource() {
        return InstantSource.system();
    }

    @Provides
    @Singleton
    public static StoreMetricsService provideStoreMetricsService(Metrics metrics) {
        return new StoreMetricsServiceImpl(metrics);
    }
}

