/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.grpc.impl.usage;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public enum UserAgentType {
    HIERO_SDK_CPP("HieroSdkCpp", true, "hiero-sdk-cpp"),
    HIERO_SDK_GO("HieroSdkGo", true, "hiero-sdk-go"),
    HIERO_SDK_JAVA("HieroSdkJava", true, "hiero-sdk-java"),
    HIERO_SDK_JS("HieroSdkJs", true, "hiero-sdk-js"),
    HIERO_SDK_PYTHON("HieroSdkPython", true, "hiero-sdk-python"),
    HIERO_SDK_RUST("HieroSdkRust", true, "hiero-sdk-rust"),
    HIERO_SDK_SWIFT("HieroSdkSwift", true, "hiero-sdk-swift"),
    UNSPECIFIED("Unspecified", false, new String[0]),
    UNKNOWN("Unknown", false, new String[0]);

    private static final Map<String, UserAgentType> values;
    private final String id;
    private final String[] variations;
    private final boolean isKnownType;

    private UserAgentType(String id, boolean isKnownType, String ... variations) {
        this.id = Objects.requireNonNull(id);
        this.isKnownType = isKnownType;
        this.variations = Objects.requireNonNull(variations);
    }

    public boolean isKnownType() {
        return this.isKnownType;
    }

    public String id() {
        return this.id;
    }

    @NonNull
    static UserAgentType fromString(@Nullable String userAgentType) {
        if (userAgentType == null || userAgentType.isBlank()) {
            return UNSPECIFIED;
        }
        String trimmedAgentType = userAgentType.trim();
        UserAgentType type = values.get(trimmedAgentType);
        if (type != null) {
            return type;
        }
        type = values.get(trimmedAgentType.toLowerCase());
        if (type != null) {
            return type;
        }
        return UNKNOWN;
    }

    static {
        values = new HashMap<String, UserAgentType>();
        for (UserAgentType userAgent : UserAgentType.values()) {
            values.put(userAgent.id, userAgent);
            if (userAgent.variations == null) continue;
            for (String altName : userAgent.variations) {
                values.put(altName.toLowerCase(), userAgent);
            }
        }
    }
}

