/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hints.schemas;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.state.hints.CRSStage;
import com.hedera.hapi.node.state.hints.CRSState;
import com.hedera.hapi.node.state.hints.HintsConstruction;
import com.hedera.hapi.platform.state.NodeId;
import com.hedera.hapi.platform.state.SingletonType;
import com.hedera.hapi.platform.state.StateKey;
import com.hedera.hapi.services.auxiliary.hints.CrsPublicationTransactionBody;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.hints.HintsLibrary;
import com.hedera.node.app.hints.impl.HintsContext;
import com.hedera.node.app.hints.schemas.V059HintsSchema;
import com.hedera.node.config.data.TssConfig;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.lifecycle.MigrationContext;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.StateDefinition;
import com.swirlds.state.lifecycle.StateMetadata;
import com.swirlds.state.spi.WritableSingletonState;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class V060HintsSchema
extends Schema<SemanticVersion> {
    private static final SemanticVersion VERSION = SemanticVersion.newBuilder().minor(60).build();
    public static final String CRS_STATE_KEY = "CRS_STATE";
    public static final int CRS_STATE_STATE_ID = SingletonType.HINTSSERVICE_I_CRS_STATE.protoOrdinal();
    public static final String CRS_STATE_STATE_LABEL = StateMetadata.computeLabel((String)"HintsService", (String)"CRS_STATE");
    public static final String CRS_PUBLICATIONS_KEY = "CRS_PUBLICATIONS";
    public static final int CRS_PUBLICATIONS_STATE_ID = StateKey.KeyOneOfType.HINTSSERVICE_I_CRS_PUBLICATIONS.protoOrdinal();
    public static final String CRS_PUBLICATIONS_STATE_LABEL = StateMetadata.computeLabel((String)"HintsService", (String)"CRS_PUBLICATIONS");
    private static final Logger log = LogManager.getLogger(V060HintsSchema.class);
    private static final long MAX_CRS_PUBLICATIONS = 1024L;
    private final HintsContext signingContext;
    private final HintsLibrary library;

    public V060HintsSchema(@NonNull HintsContext signingContext, @NonNull HintsLibrary library) {
        super((Object)VERSION, HapiUtils.SEMANTIC_VERSION_COMPARATOR);
        this.signingContext = Objects.requireNonNull(signingContext);
        this.library = Objects.requireNonNull(library);
    }

    @NonNull
    public Set<StateDefinition> statesToCreate() {
        return Set.of(StateDefinition.singleton((int)CRS_STATE_STATE_ID, (String)CRS_STATE_KEY, (Codec)CRSState.PROTOBUF), StateDefinition.onDisk((int)CRS_PUBLICATIONS_STATE_ID, (String)CRS_PUBLICATIONS_KEY, (Codec)NodeId.PROTOBUF, (Codec)CrsPublicationTransactionBody.PROTOBUF, (long)1024L));
    }

    public void migrate(@NonNull MigrationContext ctx) {
    }

    public void restart(@NonNull MigrationContext ctx) {
        TssConfig tssConfig;
        WritableSingletonState crsStateSingleton;
        WritableSingletonState nextConstructionState;
        WritableStates states = ctx.newStates();
        WritableSingletonState activeConstructionState = states.getSingleton(V059HintsSchema.ACTIVE_HINTS_CONSTRUCTION_STATE_ID);
        if (activeConstructionState.get() == null) {
            activeConstructionState.put((Object)HintsConstruction.DEFAULT);
        }
        if ((nextConstructionState = states.getSingleton(V059HintsSchema.NEXT_HINTS_CONSTRUCTION_STATE_ID)).get() == null) {
            nextConstructionState.put((Object)HintsConstruction.DEFAULT);
        }
        if ((crsStateSingleton = states.getSingleton(CRS_STATE_STATE_ID)).get() == null) {
            crsStateSingleton.put((Object)CRSState.DEFAULT);
        }
        if ((tssConfig = (TssConfig)ctx.appConfig().getConfigData(TssConfig.class)).hintsEnabled()) {
            CRSState crsState = Objects.requireNonNull((CRSState)crsStateSingleton.get());
            if (crsState.equals((Object)CRSState.DEFAULT)) {
                log.info("Initializing CRS for {} parties", (Object)tssConfig.initialCrsParties());
                Bytes initialCrs = this.library.newCrs(tssConfig.initialCrsParties());
                crsStateSingleton.put((Object)CRSState.newBuilder().stage(CRSStage.GATHERING_CONTRIBUTIONS).nextContributingNodeId(Long.valueOf(0L)).crs(initialCrs).build());
            } else if (crsState.stage() == CRSStage.COMPLETED) {
                this.signingContext.setCrs(crsState.crs());
            }
            HintsConstruction activeConstruction = (HintsConstruction)states.getSingleton(V059HintsSchema.ACTIVE_HINTS_CONSTRUCTION_STATE_ID).get();
            if (Objects.requireNonNull(activeConstruction).hasHintsScheme()) {
                this.signingContext.setConstruction(activeConstruction);
            }
        }
    }
}

