/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.info;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ServiceEndpoint;
import com.hedera.hapi.node.state.addressbook.Node;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.ids.ReadableEntityIdStoreImpl;
import com.hedera.node.app.service.addressbook.impl.ReadableNodeStoreImpl;
import com.hedera.node.app.services.StartupNetworks;
import com.hedera.node.app.spi.ids.ReadableEntityCounters;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.VersionedConfiguration;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.node.config.data.NetworkAdminConfig;
import com.hedera.node.internal.network.Network;
import com.hedera.node.internal.network.NodeMetadata;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.stream.ReadableStreamingData;
import com.hedera.pbj.runtime.io.stream.WritableStreamingData;
import com.swirlds.config.api.Configuration;
import com.swirlds.platform.config.AddressBookConfig;
import com.swirlds.platform.config.legacy.LegacyConfigProperties;
import com.swirlds.platform.config.legacy.LegacyConfigPropertiesLoader;
import com.swirlds.platform.crypto.CryptoStatic;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.roster.AddressBook;
import org.hiero.consensus.roster.RosterRetriever;

public class DiskStartupNetworks
implements StartupNetworks {
    private static final Logger log = LogManager.getLogger(DiskStartupNetworks.class);
    public static final String ARCHIVE = ".archive";
    public static final String GENESIS_NETWORK_JSON = "genesis-network.json";
    public static final String OVERRIDE_NETWORK_JSON = "override-network.json";
    public static final Pattern ROUND_DIR_PATTERN = Pattern.compile("\\d+");
    private static final String CONFIG_TXT = "config.txt";
    private final ConfigProvider configProvider;
    private boolean isArchived = false;

    public DiskStartupNetworks(@NonNull ConfigProvider configProvider) {
        this.configProvider = Objects.requireNonNull(configProvider);
    }

    @Override
    public Network genesisNetworkOrThrow(@NonNull Configuration platformConfig) {
        Objects.requireNonNull(platformConfig);
        VersionedConfiguration config = this.configProvider.getConfiguration();
        return this.loadNetwork(AssetUse.GENESIS, (Configuration)config, GENESIS_NETWORK_JSON).or(() -> this.networkFromConfigTxt(platformConfig, config)).orElseThrow(() -> new IllegalStateException("Genesis network not found"));
    }

    @Override
    public Optional<Network> overrideNetworkFor(long roundNumber, @NonNull Configuration platformConfig) {
        if (roundNumber == 0L) {
            return Optional.empty();
        }
        VersionedConfiguration config = this.configProvider.getConfiguration();
        Optional<Network> unscopedNetwork = this.loadNetwork(AssetUse.OVERRIDE, (Configuration)config, OVERRIDE_NETWORK_JSON);
        if (unscopedNetwork.isPresent()) {
            return unscopedNetwork;
        }
        Optional<Network> scopedNetwork = this.loadNetwork(AssetUse.OVERRIDE, (Configuration)config, "" + roundNumber, OVERRIDE_NETWORK_JSON);
        if (scopedNetwork.isPresent()) {
            return scopedNetwork;
        }
        if (((AddressBookConfig)platformConfig.getConfigData(AddressBookConfig.class)).forceUseOfConfigAddressBook()) {
            try {
                return this.networkFromConfigTxt(platformConfig, config);
            }
            catch (Exception e) {
                log.warn("Failed to load network from config.txt", (Throwable)e);
            }
        }
        return Optional.empty();
    }

    @Override
    public void setOverrideRound(long roundNumber) {
        VersionedConfiguration config = this.configProvider.getConfiguration();
        Path path = DiskStartupNetworks.networksPath((Configuration)config, OVERRIDE_NETWORK_JSON);
        if (Files.exists(path, new LinkOption[0])) {
            Path roundDir = DiskStartupNetworks.networksPath((Configuration)config, "" + roundNumber);
            Path scopedPath = roundDir.resolve(OVERRIDE_NETWORK_JSON);
            try {
                Files.createDirectories(roundDir, new FileAttribute[0]);
                Files.move(path, scopedPath, new CopyOption[0]);
                log.info("Moved override network file to {}", (Object)scopedPath);
            }
            catch (IOException e) {
                log.warn("Failed to move override network file", (Throwable)e);
            }
        }
    }

    @Override
    public void archiveStartupNetworks() {
        if (this.isArchived) {
            return;
        }
        this.isArchived = true;
        VersionedConfiguration config = this.configProvider.getConfiguration();
        try {
            DiskStartupNetworks.ensureArchiveDir((Configuration)config);
        }
        catch (IOException e) {
            log.warn("Failed to create archive directory", (Throwable)e);
            return;
        }
        DiskStartupNetworks.archiveIfPresent((Configuration)config, GENESIS_NETWORK_JSON);
        DiskStartupNetworks.archiveIfPresent((Configuration)config, OVERRIDE_NETWORK_JSON);
        DiskStartupNetworks.archiveIfPresent(Path.of(((NetworkAdminConfig)config.getConfigData(NetworkAdminConfig.class)).configTxtPath(), new String[0]), CONFIG_TXT);
        try (Stream<Path> dirStream = Files.list(DiskStartupNetworks.networksPath((Configuration)config, new String[0]));){
            dirStream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(dir -> ROUND_DIR_PATTERN.matcher(dir.getFileName().toString()).matches()).forEach(dir -> {
                DiskStartupNetworks.archiveIfPresent((Configuration)config, dir.getFileName().toString(), OVERRIDE_NETWORK_JSON);
                if (!dir.toFile().delete()) {
                    log.warn("Failed to delete round override network directory {}", dir);
                }
            });
        }
        catch (IOException e) {
            log.warn("Failed to list round override network files", (Throwable)e);
        }
    }

    @Override
    public Network migrationNetworkOrThrow(@NonNull Configuration platformConfig) {
        Objects.requireNonNull(platformConfig);
        VersionedConfiguration config = this.configProvider.getConfiguration();
        return this.loadNetwork(AssetUse.MIGRATION, (Configuration)config, OVERRIDE_NETWORK_JSON).or(() -> this.networkFromConfigTxt(platformConfig, config)).orElseThrow(() -> new IllegalStateException("Transplant network not found"));
    }

    public static void writeNetworkInfo(@NonNull State state, @NonNull Path path, @NonNull Set<InfoType> infoTypes, @NonNull PlatformStateFacade platformStateFacade) {
        Objects.requireNonNull(state);
        ReadableEntityIdStoreImpl entityIdStore = new ReadableEntityIdStoreImpl(state.getReadableStates("EntityIdService"));
        ReadableNodeStoreImpl nodeStore = new ReadableNodeStoreImpl(state.getReadableStates("AddressBookService"), (ReadableEntityCounters)entityIdStore);
        long round = platformStateFacade.roundOf(state);
        Optional.ofNullable(RosterRetriever.retrieveActive((State)state, (long)round)).ifPresent(activeRoster -> {
            Network.Builder network = Network.newBuilder();
            ArrayList nodeMetadata = new ArrayList();
            activeRoster.rosterEntries().forEach(entry -> {
                Node node = Objects.requireNonNull(nodeStore.get(entry.nodeId()));
                nodeMetadata.add(new NodeMetadata((RosterEntry)(infoTypes.contains((Object)InfoType.ROSTER) ? entry : null), (Node)(infoTypes.contains((Object)InfoType.NODE_DETAILS) ? node : null)));
            });
            network.nodeMetadata(nodeMetadata);
            DiskStartupNetworks.tryToExport(network.build(), path);
        });
    }

    public static void tryToExport(@NonNull Network network, @NonNull Path path) {
        try (OutputStream fout = Files.newOutputStream(path, new OpenOption[0]);){
            Network.JSON.write((Object)network, (WritableSequentialData)new WritableStreamingData(fout));
        }
        catch (IOException e) {
            log.warn("Failed to write network info", (Throwable)e);
        }
    }

    @NonNull
    public static Network fromLegacyAddressBook(@NonNull AddressBook addressBook, @NonNull VersionedConfiguration configuration) {
        Roster roster = RosterRetriever.buildRoster((AddressBook)addressBook);
        HederaConfig hederaConfig = (HederaConfig)configuration.getConfigData(HederaConfig.class);
        return Network.newBuilder().nodeMetadata(roster.rosterEntries().stream().map(rosterEntry -> {
            long nodeId = rosterEntry.nodeId();
            AccountID nodeAccountId = HapiUtils.parseAccountFromLegacy((String)addressBook.getAddress(NodeId.of((long)nodeId)).getMemo(), (long)hederaConfig.shard(), (long)hederaConfig.realm());
            List<ServiceEndpoint> legacyGossipEndpoints = List.of((ServiceEndpoint)rosterEntry.gossipEndpoint().getLast(), (ServiceEndpoint)rosterEntry.gossipEndpoint().getFirst());
            return NodeMetadata.newBuilder().rosterEntry(rosterEntry).node(Node.newBuilder().nodeId(nodeId).accountId(nodeAccountId).description("node" + (nodeId + 1L)).gossipEndpoint(legacyGossipEndpoints).serviceEndpoint(List.of()).gossipCaCertificate(rosterEntry.gossipCaCertificate()).grpcCertificateHash(Bytes.EMPTY).weight(rosterEntry.weight()).deleted(false).declineReward(true).adminKey(Key.DEFAULT).build()).build();
        }).toList()).build();
    }

    private Optional<Network> loadNetwork(@NonNull AssetUse use, @NonNull Configuration config, String ... segments) {
        Path path = DiskStartupNetworks.networksPath(config, segments);
        log.info("Checking for {} network info at {}", (Object)use, (Object)path.toAbsolutePath());
        Optional<Network> maybeNetwork = DiskStartupNetworks.loadNetworkFrom(path);
        maybeNetwork.ifPresentOrElse(network -> log.info("  -> Parsed {} network info for N={} nodes from {}", (Object)use, (Object)network.nodeMetadata().size(), (Object)path.toAbsolutePath()), () -> log.info("  -> N/A"));
        return maybeNetwork;
    }

    public static Optional<Network> loadNetworkFrom(@NonNull Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            Optional<Network> optional;
            block9: {
                InputStream fin = Files.newInputStream(path, new OpenOption[0]);
                try {
                    optional = Optional.of((Network)Network.JSON.parse((ReadableSequentialData)new ReadableStreamingData(fin)));
                    if (fin == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (fin != null) {
                            try {
                                fin.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        log.warn("Failed to load {} network info from {}", (Object)path.toAbsolutePath(), (Object)e);
                    }
                }
                fin.close();
            }
            return optional;
        }
        return Optional.empty();
    }

    @Deprecated(forRemoval=true)
    private Optional<Network> networkFromConfigTxt(@NonNull Configuration platformConfig, @NonNull VersionedConfiguration appConfig) {
        try {
            AddressBook legacyBook;
            log.info("No genesis-network.json detected, falling back to config.txt and initNodeSecurity()");
            LegacyConfigProperties configFile = LegacyConfigPropertiesLoader.loadConfigFile((Path)Paths.get(CONFIG_TXT, new String[0]));
            try {
                legacyBook = configFile.getAddressBook();
                CryptoStatic.initNodeSecurity((AddressBook)legacyBook, (Configuration)platformConfig, Set.of());
            }
            catch (Exception e) {
                throw new IllegalStateException("Error generating keys and certs", e);
            }
            Network network = DiskStartupNetworks.fromLegacyAddressBook(legacyBook, appConfig);
            return Optional.of(network);
        }
        catch (Exception e) {
            log.warn("Fallback loading genesis network from config.txt also failed", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private static void archiveIfPresent(Path basePath, String ... segments) {
        try {
            Path path = Paths.get(basePath.toAbsolutePath().toString(), segments);
            if (Files.exists(path, new LinkOption[0])) {
                String[] archiveSegments = (String[])Stream.concat(Stream.of(ARCHIVE), Stream.of(segments)).toArray(String[]::new);
                Path dest = Paths.get(basePath.toAbsolutePath().toString(), archiveSegments);
                DiskStartupNetworks.createIfAbsent(dest.getParent());
                Files.move(path, dest, new CopyOption[0]);
            }
        }
        catch (IOException e) {
            log.warn("Failed to archive {}", (Object)segments, (Object)e);
        }
    }

    private static void archiveIfPresent(@NonNull Configuration config, String ... segments) {
        DiskStartupNetworks.archiveIfPresent(DiskStartupNetworks.networksPath(config, new String[0]), segments);
    }

    private static void ensureArchiveDir(@NonNull Configuration config) throws IOException {
        DiskStartupNetworks.createIfAbsent(DiskStartupNetworks.networksPath(config, ARCHIVE));
    }

    private static void createIfAbsent(@NonNull Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectory(path, new FileAttribute[0]);
        }
    }

    private static Path networksPath(@NonNull Configuration config, String ... segments) {
        return Paths.get(((NetworkAdminConfig)config.getConfigData(NetworkAdminConfig.class)).upgradeSysFilesLoc(), segments);
    }

    private static enum AssetUse {
        GENESIS,
        OVERRIDE,
        MIGRATION;

    }

    public static enum InfoType {
        ROSTER,
        NODE_DETAILS;

    }
}

