/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.metrics;

import com.swirlds.common.metrics.RunningAverageMetric;
import com.swirlds.metrics.api.Counter;
import com.swirlds.metrics.api.DoubleGauge;
import com.swirlds.metrics.api.LongGauge;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hiero.block.api.PublishStreamRequest;
import org.hiero.block.api.PublishStreamResponse;

@Singleton
public class BlockStreamMetrics {
    private static final String CATEGORY = "blockStream";
    private static final String GROUP_CONN = "conn";
    private static final String GROUP_CONN_SEND = "connSend";
    private static final String GROUP_CONN_RECV = "connRecv";
    private static final String GROUP_BUFFER = "buffer";
    private final Metrics metrics;
    private Counter connSend_failureCounter;
    private Counter connSend_blockItemsCounter;
    private RunningAverageMetric connSend_publishStreamRequestLatency;
    private final Map<PublishStreamRequest.RequestOneOfType, Counter> connSend_counters = new EnumMap<PublishStreamRequest.RequestOneOfType, Counter>(PublishStreamRequest.RequestOneOfType.class);
    private final Map<PublishStreamRequest.EndStream.Code, Counter> connSend_endStreamCounters = new EnumMap<PublishStreamRequest.EndStream.Code, Counter>(PublishStreamRequest.EndStream.Code.class);
    private final Map<PublishStreamResponse.EndOfStream.Code, Counter> connRecv_endOfStreamCounters = new EnumMap<PublishStreamResponse.EndOfStream.Code, Counter>(PublishStreamResponse.EndOfStream.Code.class);
    private final Map<PublishStreamResponse.ResponseOneOfType, Counter> connRecv_counters = new EnumMap<PublishStreamResponse.ResponseOneOfType, Counter>(PublishStreamResponse.ResponseOneOfType.class);
    private Counter connRecv_unknownCounter;
    private LongGauge connRecv_latestBlockEndOfStreamGauge;
    private LongGauge connRecv_latestBlockSkipBlockGauge;
    private LongGauge connRecv_latestBlockResendBlockGauge;
    private Counter conn_onCompleteCounter;
    private Counter conn_onErrorCounter;
    private Counter conn_openedCounter;
    private Counter conn_closedCounter;
    private Counter conn_noActiveCounter;
    private Counter conn_createFailureCounter;
    private LongGauge conn_activeConnIpGauge;
    private Counter conn_endOfStreamLimitCounter;
    private DoubleGauge conn_ackLatencyGauge;
    private Counter conn_highLatencyCounter;
    private static final long BACK_PRESSURE_ACTIVE = 3L;
    private static final long BACK_PRESSURE_RECOVERING = 2L;
    private static final long BACK_PRESSURE_ACTION_STAGE = 1L;
    private static final long BACK_PRESSURE_DISABLED = 0L;
    private DoubleGauge buffer_saturationGauge;
    private LongGauge buffer_latestBlockOpenedGauge;
    private LongGauge buffer_latestBlockAckedGauge;
    private LongGauge buffer_backPressureStateGauge;
    private Counter buffer_numBlocksPrunedCounter;
    private Counter buffer_numBlocksOpenedCounter;
    private Counter buffer_numBlocksClosedCounter;
    private Counter buffer_numBlocksMissingCounter;
    private LongGauge buffer_oldestBlockGauge;
    private LongGauge buffer_newestBlockGauge;

    @Inject
    public BlockStreamMetrics(@NonNull Metrics metrics) {
        this.metrics = Objects.requireNonNull(metrics);
        this.registerConnectionSendMetrics();
        this.registerConnectionRecvMetrics();
        this.registerConnectivityMetrics();
        this.registerBufferMetrics();
    }

    private void registerBufferMetrics() {
        DoubleGauge.Config saturationCfg = this.newDoubleGauge(GROUP_BUFFER, "saturation").withDescription("The percent (0.0 to 100.0) of buffered blocks that haven't been acknowledged");
        this.buffer_saturationGauge = (DoubleGauge)this.metrics.getOrCreate((MetricConfig)saturationCfg);
        LongGauge.Config latestBlockOpenedCfg = this.newLongGauge(GROUP_BUFFER, "latestBlockOpened").withDescription("The block number that was most recently opened");
        this.buffer_latestBlockOpenedGauge = (LongGauge)this.metrics.getOrCreate((MetricConfig)latestBlockOpenedCfg);
        LongGauge.Config latestBlockAckedCfg = this.newLongGauge(GROUP_BUFFER, "latestBlockAcked").withDescription("The block number that was most recently acknowledged");
        this.buffer_latestBlockAckedGauge = (LongGauge)this.metrics.getOrCreate((MetricConfig)latestBlockAckedCfg);
        Counter.Config numBlocksPrunedCfg = this.newCounter(GROUP_BUFFER, "numBlocksPruned").withDescription("Number of blocks pruned in the latest buffer pruning cycle");
        this.buffer_numBlocksPrunedCounter = (Counter)this.metrics.getOrCreate((MetricConfig)numBlocksPrunedCfg);
        Counter.Config numBlocksOpenedCfg = this.newCounter(GROUP_BUFFER, "numBlocksOpened").withDescription("Number of blocks opened/created in the block buffer");
        this.buffer_numBlocksOpenedCounter = (Counter)this.metrics.getOrCreate((MetricConfig)numBlocksOpenedCfg);
        Counter.Config numBlocksClosedCfg = this.newCounter(GROUP_BUFFER, "numBlocksClosed").withDescription("Number of blocks closed in the block buffer");
        this.buffer_numBlocksClosedCounter = (Counter)this.metrics.getOrCreate((MetricConfig)numBlocksClosedCfg);
        Counter.Config numBlocksMissingCfg = this.newCounter(GROUP_BUFFER, "numBlocksMissing").withDescription("Number of attempts to retrieve a block from the block buffer but it was missing");
        this.buffer_numBlocksMissingCounter = (Counter)this.metrics.getOrCreate((MetricConfig)numBlocksMissingCfg);
        LongGauge.Config backPressureStateCfg = this.newLongGauge(GROUP_BUFFER, "backPressureState").withDescription("Current state of back pressure (0=disabled, 1=action-stage, 2=recovering, 3=active)");
        this.buffer_backPressureStateGauge = (LongGauge)this.metrics.getOrCreate((MetricConfig)backPressureStateCfg);
        LongGauge.Config oldestBlockCfg = this.newLongGauge(GROUP_BUFFER, "oldestBlock").withDescription("After pruning, the oldest block in the buffer");
        this.buffer_oldestBlockGauge = (LongGauge)this.metrics.getOrCreate((MetricConfig)oldestBlockCfg);
        LongGauge.Config newestBlockCfg = this.newLongGauge(GROUP_BUFFER, "newestBlock").withDescription("After pruning, the newest block in the buffer");
        this.buffer_newestBlockGauge = (LongGauge)this.metrics.getOrCreate((MetricConfig)newestBlockCfg);
    }

    public void recordBufferOldestBlock(long blockNumber) {
        this.buffer_oldestBlockGauge.set(blockNumber);
    }

    public void recordBufferNewestBlock(long blockNumber) {
        this.buffer_newestBlockGauge.set(blockNumber);
    }

    public void recordBufferSaturation(double saturation) {
        this.buffer_saturationGauge.set(saturation);
    }

    public void recordLatestBlockOpened(long blockNumber) {
        this.buffer_latestBlockOpenedGauge.set(blockNumber);
    }

    public void recordLatestBlockAcked(long blockNumber) {
        this.buffer_latestBlockAckedGauge.set(blockNumber);
    }

    public void recordNumberOfBlocksPruned(int numBlocksPruned) {
        if (numBlocksPruned > 0) {
            this.buffer_numBlocksPrunedCounter.add((long)numBlocksPruned);
        }
    }

    public void recordBlockOpened() {
        this.buffer_numBlocksOpenedCounter.increment();
    }

    public void recordBlockClosed() {
        this.buffer_numBlocksClosedCounter.increment();
    }

    public void recordBlockMissing() {
        this.buffer_numBlocksMissingCounter.increment();
    }

    public void recordBackPressureActive() {
        this.buffer_backPressureStateGauge.set(3L);
    }

    public void recordBackPressureActionStage() {
        this.buffer_backPressureStateGauge.set(1L);
    }

    public void recordBackPressureRecovering() {
        this.buffer_backPressureStateGauge.set(2L);
    }

    public void recordBackPressureDisabled() {
        this.buffer_backPressureStateGauge.set(0L);
    }

    private void registerConnectivityMetrics() {
        Counter.Config onCompleteCfg = this.newCounter(GROUP_CONN, "onComplete").withDescription("Number of onComplete handler invocations on block node connections");
        this.conn_onCompleteCounter = (Counter)this.metrics.getOrCreate((MetricConfig)onCompleteCfg);
        Counter.Config onErrorCfg = this.newCounter(GROUP_CONN, "onError").withDescription("Number of onError handler invocations on block node connections");
        this.conn_onErrorCounter = (Counter)this.metrics.getOrCreate((MetricConfig)onErrorCfg);
        Counter.Config openedCfg = this.newCounter(GROUP_CONN, "opened").withDescription("Number of block node connections opened");
        this.conn_openedCounter = (Counter)this.metrics.getOrCreate((MetricConfig)openedCfg);
        Counter.Config closedCfg = this.newCounter(GROUP_CONN, "closed").withDescription("Number of block node connections closed");
        this.conn_closedCounter = (Counter)this.metrics.getOrCreate((MetricConfig)closedCfg);
        Counter.Config noActiveCfg = this.newCounter(GROUP_CONN, "noActive").withDescription("Number of times streaming a block was attempted but there was no active connection");
        this.conn_noActiveCounter = (Counter)this.metrics.getOrCreate((MetricConfig)noActiveCfg);
        Counter.Config createFailureCfg = this.newCounter(GROUP_CONN, "createFailure").withDescription("Number of times establishing a block node connection failed");
        this.conn_createFailureCounter = (Counter)this.metrics.getOrCreate((MetricConfig)createFailureCfg);
        LongGauge.Config activeConnIpCfg = this.newLongGauge(GROUP_CONN, "activeConnIp").withDescription("IP address (in integer format) of the currently active block node connection");
        this.conn_activeConnIpGauge = (LongGauge)this.metrics.getOrCreate((MetricConfig)activeConnIpCfg);
        Counter.Config endOfStreamLimitCfg = this.newCounter(GROUP_CONN, "endOfStreamLimitExceeded").withDescription("Number of times the active block node connection has exceeded the allowed number of EndOfStream responses");
        this.conn_endOfStreamLimitCounter = (Counter)this.metrics.getOrCreate((MetricConfig)endOfStreamLimitCfg);
        DoubleGauge.Config ackLatencyCfg = this.newDoubleGauge(GROUP_CONN, "acknowledgementLatency").withDescription("Latency (ms) between the last sent BlockProof and the corresponding BlockAcknowledgement");
        this.conn_ackLatencyGauge = (DoubleGauge)this.metrics.getOrCreate((MetricConfig)ackLatencyCfg);
        Counter.Config highLatencyCfg = this.newCounter(GROUP_CONN, "highLatencyEvents").withDescription("Count of high latency events from the active block node connection");
        this.conn_highLatencyCounter = (Counter)this.metrics.getOrCreate((MetricConfig)highLatencyCfg);
    }

    public void recordEndOfStreamLimitExceeded() {
        this.conn_endOfStreamLimitCounter.increment();
    }

    public void recordConnectionOnComplete() {
        this.conn_onCompleteCounter.increment();
    }

    public void recordConnectionOnError() {
        this.conn_onErrorCounter.increment();
    }

    public void recordConnectionOpened() {
        this.conn_openedCounter.increment();
    }

    public void recordConnectionClosed() {
        this.conn_closedCounter.increment();
    }

    public void recordNoActiveConnection() {
        this.conn_noActiveCounter.increment();
    }

    public void recordConnectionCreateFailure() {
        this.conn_createFailureCounter.increment();
    }

    public void recordActiveConnectionIp(long ipAddress) {
        this.conn_activeConnIpGauge.set(ipAddress);
    }

    public void recordAcknowledgementLatency(long latencyMs) {
        this.conn_ackLatencyGauge.set((double)latencyMs);
    }

    public void recordHighLatencyEvent() {
        this.conn_highLatencyCounter.increment();
    }

    private void registerConnectionRecvMetrics() {
        block4: for (PublishStreamResponse.ResponseOneOfType respType : PublishStreamResponse.ResponseOneOfType.values()) {
            String respTypeName = BlockStreamMetrics.toCamelCase(respType.protoName());
            switch (respType) {
                case UNSET: {
                    continue block4;
                }
                case END_STREAM: {
                    String namePrefix = respTypeName + "_";
                    for (PublishStreamResponse.EndOfStream.Code eosCode : PublishStreamResponse.EndOfStream.Code.values()) {
                        if (PublishStreamResponse.EndOfStream.Code.UNKNOWN == eosCode) continue;
                        String name = respTypeName + "_" + BlockStreamMetrics.toCamelCase(eosCode.protoName());
                        Counter.Config cfg = this.newCounter(GROUP_CONN_RECV, namePrefix + BlockStreamMetrics.toCamelCase(eosCode.protoName())).withDescription("Number of " + name + " responses received from block nodes");
                        this.connRecv_endOfStreamCounters.put(eosCode, (Counter)this.metrics.getOrCreate((MetricConfig)cfg));
                    }
                    continue block4;
                }
                default: {
                    Counter.Config cfg = this.newCounter(GROUP_CONN_RECV, respTypeName).withDescription("Number of " + respTypeName + " responses received from block nodes");
                    this.connRecv_counters.put(respType, (Counter)this.metrics.getOrCreate((MetricConfig)cfg));
                }
            }
        }
        Counter.Config recvUnknownCfg = this.newCounter(GROUP_CONN_RECV, "unknown").withDescription("Number of responses received from block nodes that are of unknown types");
        this.connRecv_unknownCounter = (Counter)this.metrics.getOrCreate((MetricConfig)recvUnknownCfg);
        LongGauge.Config latestBlockEosCfg = this.newLongGauge(GROUP_CONN_RECV, "latestBlockEndOfStream").withDescription("The latest block number received in an EndOfStream response");
        this.connRecv_latestBlockEndOfStreamGauge = (LongGauge)this.metrics.getOrCreate((MetricConfig)latestBlockEosCfg);
        LongGauge.Config latestBlockSkipCfg = this.newLongGauge(GROUP_CONN_RECV, "latestBlockSkipBlock").withDescription("The latest block number received in a SkipBlock response");
        this.connRecv_latestBlockSkipBlockGauge = (LongGauge)this.metrics.getOrCreate((MetricConfig)latestBlockSkipCfg);
        LongGauge.Config latestBlockResendCfg = this.newLongGauge(GROUP_CONN_RECV, "latestBlockResendBlock").withDescription("The latest block number received in a ResendBlock response");
        this.connRecv_latestBlockResendBlockGauge = (LongGauge)this.metrics.getOrCreate((MetricConfig)latestBlockResendCfg);
    }

    public void recordUnknownResponseReceived() {
        this.connRecv_unknownCounter.increment();
    }

    public void recordResponseReceived(PublishStreamResponse.ResponseOneOfType responseType) {
        Counter counter = this.connRecv_counters.get(responseType);
        if (counter != null) {
            counter.increment();
        }
    }

    public void recordResponseEndOfStreamReceived(PublishStreamResponse.EndOfStream.Code responseType) {
        Counter counter = this.connRecv_endOfStreamCounters.get(responseType);
        if (counter != null) {
            counter.increment();
        }
    }

    public void recordLatestBlockEndOfStream(long blockNumber) {
        this.connRecv_latestBlockEndOfStreamGauge.set(blockNumber);
    }

    public void recordLatestBlockSkipBlock(long blockNumber) {
        this.connRecv_latestBlockSkipBlockGauge.set(blockNumber);
    }

    public void recordLatestBlockResendBlock(long blockNumber) {
        this.connRecv_latestBlockResendBlockGauge.set(blockNumber);
    }

    private void registerConnectionSendMetrics() {
        block4: for (PublishStreamRequest.RequestOneOfType reqType : PublishStreamRequest.RequestOneOfType.values()) {
            String reqTypeName = BlockStreamMetrics.toCamelCase(reqType.protoName());
            switch (reqType) {
                case UNSET: {
                    continue block4;
                }
                case END_STREAM: {
                    for (PublishStreamRequest.EndStream.Code esCode : PublishStreamRequest.EndStream.Code.values()) {
                        if (PublishStreamRequest.EndStream.Code.UNKNOWN == esCode) continue;
                        String name = reqTypeName + "_" + BlockStreamMetrics.toCamelCase(esCode.protoName());
                        Counter.Config cfg = this.newCounter(GROUP_CONN_SEND, name).withDescription("Number of " + name + " requests sent to block nodes");
                        this.connSend_endStreamCounters.put(esCode, (Counter)this.metrics.getOrCreate((MetricConfig)cfg));
                    }
                    continue block4;
                }
                default: {
                    Counter.Config cfg = this.newCounter(GROUP_CONN_SEND, reqTypeName).withDescription("Number of " + reqTypeName + " requests sent to the block nodes");
                    this.connSend_counters.put(reqType, (Counter)this.metrics.getOrCreate((MetricConfig)cfg));
                }
            }
        }
        Counter.Config sendFailureCfg = this.newCounter(GROUP_CONN_SEND, "failure").withDescription("Number of requests sent to block nodes that failed");
        this.connSend_failureCounter = (Counter)this.metrics.getOrCreate((MetricConfig)sendFailureCfg);
        Counter.Config blockItemsCfg = this.newCounter(GROUP_CONN_SEND, "blockItemCount").withDescription("Number of individual block items sent to block nodes");
        this.connSend_blockItemsCounter = (Counter)this.metrics.getOrCreate((MetricConfig)blockItemsCfg);
        RunningAverageMetric.Config publishStreamRequestLatencyCfg = new RunningAverageMetric.Config(CATEGORY, "connSend_requestSendLatency").withDescription("The average latency (ms) for a PublishStreamRequest to be sent to a block node").withFormat("%,.2f");
        this.connSend_publishStreamRequestLatency = (RunningAverageMetric)this.metrics.getOrCreate((MetricConfig)publishStreamRequestLatencyCfg);
    }

    public void recordRequestSent(PublishStreamRequest.RequestOneOfType requestType) {
        Counter counter = this.connSend_counters.get(requestType);
        if (counter != null) {
            counter.increment();
        }
    }

    public void recordBlockItemsSent(int numBlockItems) {
        if (numBlockItems > 0) {
            this.connSend_blockItemsCounter.add((long)numBlockItems);
        }
    }

    public void recordRequestEndStreamSent(PublishStreamRequest.EndStream.Code requestType) {
        Counter counter = this.connSend_endStreamCounters.get(requestType);
        if (counter != null) {
            counter.increment();
        }
    }

    public void recordRequestLatency(long latencyMs) {
        this.connSend_publishStreamRequestLatency.update((double)latencyMs);
    }

    public void recordRequestSendFailure() {
        this.connSend_failureCounter.increment();
    }

    private static String toCamelCase(String in) {
        StringBuilder sb = new StringBuilder(in.toLowerCase());
        int index = sb.indexOf("_");
        while (index != -1) {
            if (index == sb.length() - 1) {
                sb.deleteCharAt(index);
            } else {
                char nextChar = sb.charAt(index + 1);
                nextChar = Character.toUpperCase(nextChar);
                sb.deleteCharAt(index + 1);
                sb.replace(index, index + 1, "" + nextChar);
            }
            index = sb.indexOf("_");
        }
        return sb.toString();
    }

    private Counter.Config newCounter(String group, String metric) {
        String metricName = group + "_" + metric;
        return new Counter.Config(CATEGORY, metricName);
    }

    private DoubleGauge.Config newDoubleGauge(String group, String metric) {
        String metricName = group + "_" + metric;
        return new DoubleGauge.Config(CATEGORY, metricName);
    }

    private LongGauge.Config newLongGauge(String group, String metric) {
        String metricName = group + "_" + metric;
        return new LongGauge.Config(CATEGORY, metricName);
    }
}

