/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.records.impl.producers.formats.v6;

import com.hedera.hapi.streams.SidecarType;
import com.hedera.hapi.streams.TransactionSidecarRecord;
import com.hedera.hapi.streams.schema.SidecarFileSchema;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.WritableStreamingData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.EnumSet;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.hiero.base.crypto.HashingOutputStream;

final class SidecarWriterV6
implements AutoCloseable {
    private final int maxSideCarSizeInBytes;
    private final OutputStream hashingDelegateStream;
    private final HashingOutputStream hashingOutputStream;
    private final WritableStreamingData outputStream;
    private final EnumSet<SidecarType> sidecarTypes = EnumSet.noneOf(SidecarType.class);
    private Bytes hash = null;
    private long bytesWritten;
    private final int id;

    SidecarWriterV6(@NonNull Path file, int maxSideCarSizeInBytes, int id) throws IOException {
        MessageDigest wholeFileDigest;
        this.id = id;
        this.maxSideCarSizeInBytes = maxSideCarSizeInBytes;
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        try {
            wholeFileDigest = MessageDigest.getInstance("SHA-384");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        OutputStream fout = Files.newOutputStream(file, new OpenOption[0]);
        GZIPOutputStream gout = new GZIPOutputStream(fout);
        this.hashingDelegateStream = gout;
        this.hashingOutputStream = new HashingOutputStream(wholeFileDigest, (OutputStream)gout);
        BufferedOutputStream bout = new BufferedOutputStream((OutputStream)this.hashingOutputStream);
        this.outputStream = new WritableStreamingData((OutputStream)bout);
    }

    public int id() {
        return this.id;
    }

    boolean writeTransactionSidecarRecord(@NonNull TransactionSidecarRecord.SidecarRecordsOneOfType sidecarType, @NonNull Bytes transactionSidecarRecord) {
        if (this.bytesWritten + transactionSidecarRecord.length() > (long)this.maxSideCarSizeInBytes) {
            return false;
        }
        switch (sidecarType) {
            case ACTIONS: {
                this.sidecarTypes.add(SidecarType.CONTRACT_ACTION);
                break;
            }
            case BYTECODE: {
                this.sidecarTypes.add(SidecarType.CONTRACT_BYTECODE);
                break;
            }
            case STATE_CHANGES: {
                this.sidecarTypes.add(SidecarType.CONTRACT_STATE_CHANGE);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf(sidecarType));
            }
        }
        this.bytesWritten += transactionSidecarRecord.length();
        this.outputStream.writeVarInt(SidecarFileSchema.SIDECAR_RECORDS.number() << 3 | 2, false);
        this.outputStream.writeVarInt((int)transactionSidecarRecord.length(), false);
        this.outputStream.writeBytes((RandomAccessData)transactionSidecarRecord);
        return true;
    }

    Bytes fileHash() {
        return this.hash;
    }

    List<SidecarType> types() {
        return List.copyOf(this.sidecarTypes);
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
        this.hashingDelegateStream.close();
        this.hash = Bytes.wrap((byte[])this.hashingOutputStream.getDigest());
    }
}

