/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.roster;

import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.hedera.node.app.roster.RosterTransitionWeights;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hiero.consensus.roster.ReadableRosterStore;

public class ActiveRosters {
    private static final int HEX_PREFIX_LENGTH = 6;
    private final Phase phase;
    @Nullable
    private final Bytes sourceRosterHash;
    private final Bytes targetRosterHash;
    private final Function<Bytes, Roster> lookup;

    public static ActiveRosters from(@NonNull ReadableRosterStore rosterStore) {
        Bytes currentRosterHash = Objects.requireNonNull(rosterStore.getCurrentRosterHash());
        Bytes candidateRosterHash = rosterStore.getCandidateRosterHash();
        if (candidateRosterHash == null) {
            if (rosterStore.getPreviousRosterHash() == null) {
                return new ActiveRosters(Phase.BOOTSTRAP, currentRosterHash, currentRosterHash, arg_0 -> ((ReadableRosterStore)rosterStore).get(arg_0));
            }
            return new ActiveRosters(Phase.HANDOFF, null, currentRosterHash, arg_0 -> ((ReadableRosterStore)rosterStore).get(arg_0));
        }
        return new ActiveRosters(Phase.TRANSITION, currentRosterHash, candidateRosterHash, arg_0 -> ((ReadableRosterStore)rosterStore).get(arg_0));
    }

    private ActiveRosters(@NonNull Phase phase, @Nullable Bytes sourceRosterHash, @NonNull Bytes targetRosterHash, @NonNull Function<Bytes, Roster> lookup) {
        this.phase = Objects.requireNonNull(phase);
        this.lookup = Objects.requireNonNull(lookup);
        this.sourceRosterHash = sourceRosterHash;
        this.targetRosterHash = Objects.requireNonNull(targetRosterHash);
    }

    public Phase phase() {
        return this.phase;
    }

    @Nullable
    public Roster findRelatedRoster(@NonNull Bytes rosterHash) {
        return this.lookup.apply(rosterHash);
    }

    @NonNull
    public Bytes currentRosterHash() {
        return switch (this.phase.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 2 -> this.targetRosterHash;
            case 1 -> Objects.requireNonNull(this.sourceRosterHash);
        };
    }

    @NonNull
    public Bytes sourceRosterHash() {
        switch (this.phase.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                throw new IllegalStateException("No source roster hash in handoff phase");
            }
        }
        return Objects.requireNonNull(this.sourceRosterHash);
    }

    @NonNull
    public Bytes targetRosterHash() {
        switch (this.phase.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                throw new IllegalStateException("No target roster hash in handoff phase");
            }
        }
        return this.targetRosterHash;
    }

    @NonNull
    public Roster targetRoster() {
        switch (this.phase.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                throw new IllegalStateException("No target roster in handoff phase");
            }
        }
        return this.lookup.apply(this.targetRosterHash);
    }

    @NonNull
    public Roster currentRoster() {
        return this.lookup.apply(this.currentRosterHash());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RosterTransitionWeights transitionWeights() {
        switch (this.phase.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: 
            case 1: {
                return new RosterTransitionWeights(ActiveRosters.weightsFrom(this.lookup.apply(this.sourceRosterHash)), ActiveRosters.weightsFrom(this.lookup.apply(this.targetRosterHash)));
            }
            case 2: {
                throw new IllegalStateException("No target roster in handoff phase");
            }
        }
    }

    public SortedSet<Long> removedNodeIds() {
        return this.lookup.apply(this.sourceRosterHash).rosterEntries().stream().map(RosterEntry::nodeId).filter(arg_0 -> ActiveRosters.lambda$removedNodeIds$0(switch (this.phase.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1 -> this.lookup.apply(this.targetRosterHash).rosterEntries().stream().map(RosterEntry::nodeId).collect(Collectors.toSet());
            case 2 -> throw new IllegalStateException("No target roster in handoff phase");
        }, arg_0)).collect(Collectors.toCollection(TreeSet::new));
    }

    public String toString() {
        return "ActiveRosters{phase=" + String.valueOf((Object)this.phase) + ", source=" + Optional.ofNullable(this.sourceRosterHash).map(ActiveRosters::toHex).orElse("<NONE>") + ", target=" + ActiveRosters.toHex(this.targetRosterHash) + "}";
    }

    private static String toHex(@NonNull Bytes bytes) {
        return bytes.toHex().substring(0, 6) + "...";
    }

    @NonNull
    private static SortedMap<Long, Long> weightsFrom(@NonNull Roster roster) {
        return Objects.requireNonNull(roster).rosterEntries().stream().collect(Collectors.toMap(RosterEntry::nodeId, RosterEntry::weight, (a, b) -> a, TreeMap::new));
    }

    private static /* synthetic */ boolean lambda$removedNodeIds$0(Set targetNodeIds, Long o) {
        return !targetNodeIds.contains(o);
    }

    public static enum Phase {
        BOOTSTRAP,
        TRANSITION,
        HANDOFF;

    }
}

