/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.services;

import com.hedera.hapi.block.stream.output.StateChange;
import com.hedera.hapi.block.stream.output.StateChanges;
import com.hedera.node.app.blocks.impl.BoundaryStateChangeListener;
import com.hedera.node.app.blocks.impl.ImmediateStateChangeListener;
import com.hedera.node.app.spi.metrics.StoreMetricsService;
import com.hedera.node.config.data.BlockStreamConfig;
import com.hedera.node.config.types.StreamMode;
import com.swirlds.config.api.Configuration;
import com.swirlds.state.State;
import com.swirlds.state.StateChangeListener;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class MigrationStateChanges {
    private final List<List<StateChange>> stateChanges = new ArrayList<List<StateChange>>();
    private final ImmediateStateChangeListener immediateStateChangeListener = new ImmediateStateChangeListener();
    private final BoundaryStateChangeListener roundStateChangeListener;
    private final State state;

    public MigrationStateChanges(@NonNull State state, @NonNull Configuration config, @NonNull StoreMetricsService storeMetricsService) {
        Objects.requireNonNull(config);
        Objects.requireNonNull(storeMetricsService);
        this.state = Objects.requireNonNull(state);
        this.roundStateChangeListener = new BoundaryStateChangeListener(storeMetricsService, () -> config);
        if (((BlockStreamConfig)config.getConfigData(BlockStreamConfig.class)).streamMode() != StreamMode.RECORDS) {
            state.registerCommitListener((StateChangeListener)this.immediateStateChangeListener);
            state.registerCommitListener((StateChangeListener)this.roundStateChangeListener);
        }
    }

    public void trackCommit() {
        List<StateChange> maybeKvChanges = this.immediateStateChangeListener.getKvStateChanges();
        if (!maybeKvChanges.isEmpty()) {
            this.stateChanges.add(new ArrayList<StateChange>(maybeKvChanges));
            this.immediateStateChangeListener.resetKvStateChanges(null);
        }
    }

    public List<StateChanges.Builder> getStateChanges() {
        List<StateChange> roundChanges = this.roundStateChangeListener.allStateChanges();
        if (!roundChanges.isEmpty()) {
            this.stateChanges.add(roundChanges);
        }
        this.state.unregisterCommitListener((StateChangeListener)this.immediateStateChangeListener);
        this.state.unregisterCommitListener((StateChangeListener)this.roundStateChangeListener);
        return this.stateChanges.stream().map(changes -> StateChanges.newBuilder().stateChanges(changes)).toList();
    }
}

