/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.signature.impl;

import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.SignaturePair;
import com.hedera.node.app.hapi.utils.MiscCryptoUtils;
import com.hedera.node.app.signature.ExpandedSignaturePair;
import com.hedera.node.app.signature.SignatureVerificationFuture;
import com.hedera.node.app.signature.SignatureVerifier;
import com.hedera.node.app.signature.impl.SignatureVerificationFutureImpl;
import com.hedera.node.app.spi.signatures.SignatureVerifier;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hiero.base.crypto.Cryptography;
import org.hiero.base.crypto.CryptographyProvider;
import org.hiero.base.crypto.SignatureType;
import org.hiero.base.crypto.TransactionSignature;

@Singleton
public final class SignatureVerifierImpl
implements SignatureVerifier {
    private final Cryptography cryptoEngine;

    @Inject
    public SignatureVerifierImpl() {
        this(CryptographyProvider.getInstance());
    }

    SignatureVerifierImpl(@NonNull Cryptography cryptoEngine) {
        this.cryptoEngine = Objects.requireNonNull(cryptoEngine);
    }

    @Override
    @NonNull
    public Map<Key, SignatureVerificationFuture> verify(@NonNull Bytes signedBytes, @NonNull Set<ExpandedSignaturePair> sigs, @NonNull SignatureVerifier.MessageType messageType) {
        Objects.requireNonNull(signedBytes);
        Objects.requireNonNull(sigs);
        Objects.requireNonNull(messageType);
        if (messageType == SignatureVerifier.MessageType.KECCAK_256_HASH && signedBytes.length() != 32L) {
            throw new IllegalArgumentException("Message type " + String.valueOf(SignatureVerifier.MessageType.KECCAK_256_HASH) + " must be 32 bytes long, got '" + signedBytes.toHex() + "'");
        }
        HashMap<Key, SignatureVerificationFuture> futures = HashMap.newHashMap(sigs.size());
        for (ExpandedSignaturePair sigPair : sigs) {
            TransactionSignature txSig;
            SignaturePair.SignatureOneOfType kind = (SignaturePair.SignatureOneOfType)sigPair.sigPair().signature().kind();
            if (kind == SignaturePair.SignatureOneOfType.ECDSA_SECP256K1) {
                Bytes message = signedBytes;
                if (messageType == SignatureVerifier.MessageType.RAW) {
                    message = MiscCryptoUtils.keccak256DigestOf((Bytes)message);
                }
                txSig = new TransactionSignature(message, sigPair.keyBytes(), sigPair.signature(), SignatureType.ECDSA_SECP256K1);
            } else if (kind == SignaturePair.SignatureOneOfType.ED25519) {
                txSig = new TransactionSignature(signedBytes, sigPair.keyBytes(), sigPair.signature(), SignatureType.ED25519);
            } else {
                throw new IllegalArgumentException("Unsupported signature type: " + String.valueOf(kind));
            }
            this.cryptoEngine.verifySync(txSig);
            SignatureVerificationFutureImpl future = new SignatureVerificationFutureImpl(sigPair.key(), sigPair.evmAlias(), txSig);
            futures.put(sigPair.key(), future);
        }
        return futures;
    }
}

