/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.operations;

import com.hedera.node.app.service.contract.impl.exec.AddressChecks;
import com.hedera.node.app.service.contract.impl.exec.FeatureFlags;
import com.hedera.node.app.service.contract.impl.exec.operations.BasicCustomCallOperation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.DelegateCallOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class CustomDelegateCallOperation
extends DelegateCallOperation
implements BasicCustomCallOperation {
    private final AddressChecks addressChecks;
    private final FeatureFlags featureFlags;

    public CustomDelegateCallOperation(@NonNull GasCalculator gasCalculator, @NonNull AddressChecks addressChecks, @NonNull FeatureFlags featureFlags) {
        super(Objects.requireNonNull(gasCalculator));
        this.addressChecks = Objects.requireNonNull(addressChecks);
        this.featureFlags = featureFlags;
    }

    @Override
    public AddressChecks addressChecks() {
        return this.addressChecks;
    }

    @Override
    public FeatureFlags featureFlags() {
        return this.featureFlags;
    }

    @Override
    public Address to(@NonNull MessageFrame frame) {
        return super.to(frame);
    }

    @Override
    public Operation.OperationResult executeUnchecked(@NonNull MessageFrame frame, @NonNull EVM evm) {
        return super.execute(frame, evm);
    }

    public Operation.OperationResult execute(@NonNull MessageFrame frame, @NonNull EVM evm) {
        return BasicCustomCallOperation.super.executeChecked(frame, evm);
    }
}

