/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.scope;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.node.app.service.contract.ReadableEvmHookStore;
import com.hedera.node.app.service.contract.impl.annotations.QueryScope;
import com.hedera.node.app.service.contract.impl.exec.scope.HederaNativeOperations;
import com.hedera.node.app.service.contract.impl.exec.scope.VerificationStrategy;
import com.hedera.node.app.service.schedule.ReadableScheduleStore;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableNftStore;
import com.hedera.node.app.service.token.ReadableTokenRelationStore;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.spi.ids.EntityIdFactory;
import com.hedera.node.app.spi.workflows.QueryContext;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import org.hyperledger.besu.evm.frame.MessageFrame;

@QueryScope
public class QueryHederaNativeOperations
implements HederaNativeOperations {
    private final QueryContext context;
    private final EntityIdFactory entityIdFactory;

    @Override
    public boolean checkForCustomFees(@NonNull CryptoTransferTransactionBody op) {
        throw new UnsupportedOperationException("Cannot dispatch child transfers in query context");
    }

    @Inject
    public QueryHederaNativeOperations(@NonNull QueryContext context, @NonNull EntityIdFactory entityIdFactory) {
        this.context = Objects.requireNonNull(context);
        this.entityIdFactory = Objects.requireNonNull(entityIdFactory);
    }

    @Override
    @NonNull
    public ReadableNftStore readableNftStore() {
        return (ReadableNftStore)this.context.createStore(ReadableNftStore.class);
    }

    @Override
    @NonNull
    public ReadableTokenRelationStore readableTokenRelationStore() {
        return (ReadableTokenRelationStore)this.context.createStore(ReadableTokenRelationStore.class);
    }

    @Override
    @NonNull
    public ReadableTokenStore readableTokenStore() {
        return (ReadableTokenStore)this.context.createStore(ReadableTokenStore.class);
    }

    @Override
    @NonNull
    public ReadableAccountStore readableAccountStore() {
        return (ReadableAccountStore)this.context.createStore(ReadableAccountStore.class);
    }

    @Override
    @NonNull
    public ReadableScheduleStore readableScheduleStore() {
        return (ReadableScheduleStore)this.context.createStore(ReadableScheduleStore.class);
    }

    @Override
    @NonNull
    public ReadableEvmHookStore readableHookStore() {
        return (ReadableEvmHookStore)this.context.createStore(ReadableEvmHookStore.class);
    }

    @Override
    public void setNonce(long contractNumber, long nonce) {
        throw new UnsupportedOperationException("Cannot set nonce in query context");
    }

    @Override
    public ResponseCodeEnum createHollowAccount(@NonNull Bytes evmAddress) {
        throw new UnsupportedOperationException("Cannot create hollow account in query context");
    }

    @Override
    public void finalizeHollowAccountAsContract(@NonNull Bytes evmAddress) {
        throw new UnsupportedOperationException("Cannot finalize hollow account as contract in query context");
    }

    @Override
    public boolean canScheduleContractCall(long expiry, long gasLimit, @NonNull AccountID payerId) {
        return false;
    }

    @Override
    public ResponseCodeEnum transferWithReceiverSigCheck(long amount, AccountID fromEntityId, AccountID toEntityId, @NonNull VerificationStrategy strategy) {
        throw new UnsupportedOperationException("Cannot transfer value in query context");
    }

    @Override
    public void trackSelfDestructBeneficiary(AccountID deletedId, AccountID beneficiaryId, @NonNull MessageFrame frame) {
        throw new UnsupportedOperationException("Cannot track deletion in query context");
    }

    @Override
    public TransactionID getTransactionID() {
        throw new UnsupportedOperationException("Cannot get top level transaction ID in query context");
    }

    @Override
    public EntityIdFactory entityIdFactory() {
        return this.entityIdFactory;
    }

    @Override
    public Configuration configuration() {
        return this.context.configuration();
    }
}

