/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.precompile.AbstractPrecompiledContract;
import org.hyperledger.besu.evm.precompile.PrecompiledContract;

public abstract class AbstractFullContract
extends AbstractPrecompiledContract {
    protected AbstractFullContract(@NonNull String name, @NonNull GasCalculator gasCalculator) {
        super(Objects.requireNonNull(name), Objects.requireNonNull(gasCalculator));
    }

    public long gasRequirement(Bytes bytes) {
        throw new UnsupportedOperationException(this.getName() + " requires a MessageFrame to compute gas.  Gas requirement using the input bytes is not supported on Hedera.");
    }

    @NonNull
    public PrecompiledContract.PrecompileContractResult computePrecompile(Bytes input, @NonNull MessageFrame frame) {
        throw new UnsupportedOperationException(this.getName() + " only supports full results.  This operation is not supported on Hedera.");
    }
}

