/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.getevmaddressalias;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.HasCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.getevmaddressalias.EvmAddressAliasTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.ReturnTypes;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.service.token.AliasUtils;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public class EvmAddressAliasCall
extends AbstractCall {
    private final Address address;

    public EvmAddressAliasCall(@NonNull HasCallAttempt attempt, Address address) {
        super(attempt.systemContractGasCalculator(), attempt.enhancement(), true);
        this.address = Objects.requireNonNull(address);
    }

    @Override
    @NonNull
    public Call.PricedResult execute() {
        byte[] explicitAddress = ConversionUtils.explicitFromHeadlong(this.address);
        if (!ConversionUtils.isLongZero(this.address)) {
            return Call.PricedResult.gasOnly(this.fullResultsFor(ResponseCodeEnum.INVALID_ACCOUNT_ID, ReturnTypes.ZERO_ADDRESS), ResponseCodeEnum.INVALID_ACCOUNT_ID, true);
        }
        AccountID accountID = this.enhancement.nativeOperations().entityIdFactory().newAccountId(ConversionUtils.numberOfLongZero(explicitAddress));
        Account account = this.enhancement.nativeOperations().getAccount(accountID);
        if (account == null) {
            return Call.PricedResult.gasOnly(this.fullResultsFor(ResponseCodeEnum.INVALID_ACCOUNT_ID, ReturnTypes.ZERO_ADDRESS), ResponseCodeEnum.INVALID_ACCOUNT_ID, true);
        }
        Bytes evmAlias = AliasUtils.extractEvmAddress((Bytes)account.alias());
        if (evmAlias == null) {
            return Call.PricedResult.gasOnly(this.fullResultsFor(ResponseCodeEnum.INVALID_ACCOUNT_ID, ReturnTypes.ZERO_ADDRESS), ResponseCodeEnum.INVALID_ACCOUNT_ID, true);
        }
        Address aliasAddress = ConversionUtils.asHeadlongAddress(evmAlias.toByteArray());
        return Call.PricedResult.gasOnly(this.fullResultsFor(ResponseCodeEnum.SUCCESS, aliasAddress), ResponseCodeEnum.SUCCESS, true);
    }

    @NonNull
    private FullResult fullResultsFor(@NonNull ResponseCodeEnum responseCode, @NonNull Address address) {
        return FullResult.successResult(EvmAddressAliasTranslator.EVM_ADDRESS_ALIAS.getOutputs().encode((Object)Tuple.of((Object)responseCode.protoOrdinal(), (Object)address)), this.gasCalculator.viewGasRequirement());
    }
}

