/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.burn;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.esaulpaugh.headlong.abi.TupleType;
import com.google.common.primitives.Longs;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.token.TokenBurnTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.DispatchForResponseCodeHtsCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.burn.BurnTranslator;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class BurnDecoder {
    private static final TupleType BURN_RESULT_ENCODER = TupleType.parse((String)"(int64,int64)");
    public static final DispatchForResponseCodeHtsCall.OutputFn BURN_OUTPUT_FN = recordBuilder -> BURN_RESULT_ENCODER.encode((Object)Tuple.of((Object)recordBuilder.status().protoOrdinal(), (Object)recordBuilder.getNewTotalSupply()));

    @Inject
    public BurnDecoder() {
    }

    public TransactionBody decodeBurn(@NonNull HtsCallAttempt attempt) {
        Tuple call = BurnTranslator.BURN_TOKEN_V1.decodeCall(attempt.inputBytes());
        return this.synthBurnBody((Address)call.get(0), ((BigInteger)call.get(1)).longValueExact(), Longs.asList((long[])((long[])call.get(2))), attempt);
    }

    public TransactionBody decodeBurnV2(@NonNull HtsCallAttempt attempt) {
        Tuple call = BurnTranslator.BURN_TOKEN_V2.decodeCall(attempt.inputBytes());
        return this.synthBurnBody((Address)call.get(0), (Long)call.get(1), Longs.asList((long[])((long[])call.get(2))), attempt);
    }

    private TransactionBody synthBurnBody(@NonNull Address tokenAddress, long maybeAmount, @NonNull List<Long> maybeSerialNos, @NonNull HtsCallAttempt attempt) {
        Token maybeToken = null;
        long tokenNum = 0L;
        if (ConversionUtils.isLongZero(tokenAddress)) {
            byte[] explicit = ConversionUtils.explicitFromHeadlong(tokenAddress);
            maybeToken = attempt.linkedToken(ConversionUtils.asEvmAddress(ConversionUtils.numberOfLongZero(explicit)));
            tokenNum = ConversionUtils.numberOfLongZero(explicit);
        }
        boolean isNonFungible = maybeToken != null && maybeToken.tokenType() == TokenType.NON_FUNGIBLE_UNIQUE;
        TokenID tokenId = maybeToken != null ? maybeToken.tokenIdOrThrow() : TokenID.newBuilder().tokenNum(tokenNum).build();
        return TransactionBody.newBuilder().tokenBurn(this.burn(tokenId, isNonFungible, maybeAmount, maybeSerialNos)).build();
    }

    private TokenBurnTransactionBody burn(@NonNull TokenID tokenID, boolean isNonFungible, long amount, @NonNull List<Long> serialNos) {
        TokenBurnTransactionBody.Builder builder = TokenBurnTransactionBody.newBuilder().token(tokenID);
        if (isNonFungible) {
            builder.serialNumbers(serialNos);
        } else {
            builder.amount(amount);
        }
        return builder.build();
    }
}

