/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.create;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.scope.HederaNativeOperations;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.AddressIdConverter;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.create.ClassicCreatesCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.create.CreateDecoderFunction;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public abstract class CreateCommonTranslator
extends AbstractCallTranslator<HtsCallAttempt> {
    protected ConcurrentHashMap<SystemContractMethod, CreateDecoderFunction> createMethodsMap = new ConcurrentHashMap();

    protected CreateCommonTranslator(@NonNull SystemContractMethod.SystemContract systemContractKind, @NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(systemContractKind, systemContractMethodRegistry, contractMetrics);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HtsCallAttempt attempt) {
        return this.createMethodsMap.keySet().stream().filter(method -> attempt.isMethod((SystemContractMethod)method).isPresent()).findFirst();
    }

    @Override
    public Call callFrom(@NonNull HtsCallAttempt attempt) {
        return new ClassicCreatesCall(attempt.systemContractGasCalculator(), attempt.enhancement(), this.nominalBodyFor(attempt), attempt.defaultVerificationStrategy(), attempt.senderId());
    }

    @Nullable
    private TransactionBody nominalBodyFor(@NonNull HtsCallAttempt attempt) {
        byte[] inputBytes = attempt.inputBytes();
        AccountID senderId = attempt.senderId();
        HederaNativeOperations nativeOperations = attempt.nativeOperations();
        AddressIdConverter addressIdConverter = attempt.addressIdConverter();
        return this.createMethodsMap.entrySet().stream().filter(entry -> attempt.isSelector((SystemContractMethod)entry.getKey())).map(entry -> ((CreateDecoderFunction)entry.getValue()).decode(inputBytes, senderId, nativeOperations, addressIdConverter)).findFirst().orElse(null);
    }
}

