/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.v034;

import com.hedera.node.app.service.contract.impl.annotations.CustomOps;
import com.hedera.node.app.service.contract.impl.annotations.ServicesV034;
import com.hedera.node.app.service.contract.impl.exec.AddressChecks;
import com.hedera.node.app.service.contract.impl.exec.FeatureFlags;
import com.hedera.node.app.service.contract.impl.exec.FrameRunner;
import com.hedera.node.app.service.contract.impl.exec.TransactionProcessor;
import com.hedera.node.app.service.contract.impl.exec.gas.CustomGasCharging;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.operations.CustomBalanceOperation;
import com.hedera.node.app.service.contract.impl.exec.operations.CustomCallCodeOperation;
import com.hedera.node.app.service.contract.impl.exec.operations.CustomCallOperation;
import com.hedera.node.app.service.contract.impl.exec.operations.CustomChainIdOperation;
import com.hedera.node.app.service.contract.impl.exec.operations.CustomCreate2Operation;
import com.hedera.node.app.service.contract.impl.exec.operations.CustomCreateOperation;
import com.hedera.node.app.service.contract.impl.exec.operations.CustomDelegateCallOperation;
import com.hedera.node.app.service.contract.impl.exec.operations.CustomExtCodeCopyOperation;
import com.hedera.node.app.service.contract.impl.exec.operations.CustomExtCodeHashOperation;
import com.hedera.node.app.service.contract.impl.exec.operations.CustomExtCodeSizeOperation;
import com.hedera.node.app.service.contract.impl.exec.operations.CustomLogOperation;
import com.hedera.node.app.service.contract.impl.exec.operations.CustomPrevRandaoOperation;
import com.hedera.node.app.service.contract.impl.exec.operations.CustomSLoadOperation;
import com.hedera.node.app.service.contract.impl.exec.operations.CustomSStoreOperation;
import com.hedera.node.app.service.contract.impl.exec.operations.CustomSelfDestructOperation;
import com.hedera.node.app.service.contract.impl.exec.operations.CustomStaticCallOperation;
import com.hedera.node.app.service.contract.impl.exec.processors.CustomContractCreationProcessor;
import com.hedera.node.app.service.contract.impl.exec.processors.CustomMessageCallProcessor;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.HederaSystemContract;
import com.hedera.node.app.service.contract.impl.exec.utils.FrameBuilder;
import com.hedera.node.app.service.contract.impl.exec.v030.Version030AddressChecks;
import com.hedera.node.app.service.contract.impl.exec.v034.Version034FeatureFlags;
import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import dagger.multibindings.IntoSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.EvmSpecVersion;
import org.hyperledger.besu.evm.MainnetEVMs;
import org.hyperledger.besu.evm.code.CodeFactory;
import org.hyperledger.besu.evm.contractvalidation.ContractValidationRule;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.EvmConfiguration;
import org.hyperledger.besu.evm.operation.Operation;
import org.hyperledger.besu.evm.operation.OperationRegistry;
import org.hyperledger.besu.evm.operation.SLoadOperation;
import org.hyperledger.besu.evm.operation.SStoreOperation;
import org.hyperledger.besu.evm.precompile.MainnetPrecompiledContracts;
import org.hyperledger.besu.evm.precompile.PrecompileContractRegistry;
import org.hyperledger.besu.evm.processor.ContractCreationProcessor;

@Module
public interface V034Module {
    @Provides
    @Singleton
    @ServicesV034
    public static TransactionProcessor provideTransactionProcessor(@NonNull FrameBuilder frameBuilder, @NonNull FrameRunner frameRunner, @ServicesV034 @NonNull CustomMessageCallProcessor messageCallProcessor, @ServicesV034 @NonNull ContractCreationProcessor contractCreationProcessor, @NonNull CustomGasCharging gasCharging, @ServicesV034 @NonNull FeatureFlags featureFlags, @NonNull CodeFactory codeFactory) {
        return new TransactionProcessor(frameBuilder, frameRunner, gasCharging, messageCallProcessor, contractCreationProcessor, featureFlags, codeFactory);
    }

    @Provides
    @Singleton
    @ServicesV034
    public static ContractCreationProcessor provideContractCreationProcessor(@ServicesV034 @NonNull EVM evm, @NonNull Set<ContractValidationRule> validationRules) {
        return new CustomContractCreationProcessor(evm, true, List.copyOf(validationRules), 1L);
    }

    @Provides
    @Singleton
    @ServicesV034
    public static CustomMessageCallProcessor provideMessageCallProcessor(@ServicesV034 @NonNull EVM evm, @ServicesV034 @NonNull FeatureFlags featureFlags, @ServicesV034 @NonNull AddressChecks addressChecks, @ServicesV034 @NonNull PrecompileContractRegistry registry, @NonNull Map<Address, HederaSystemContract> systemContracts, @NonNull ContractMetrics contractMetrics) {
        return new CustomMessageCallProcessor(evm, featureFlags, registry, addressChecks, systemContracts, contractMetrics);
    }

    @Provides
    @Singleton
    @ServicesV034
    public static EVM provideEVM(@ServicesV034 @NonNull Set<Operation> customOperations, @NonNull EvmConfiguration evmConfiguration, @NonNull GasCalculator gasCalculator, @CustomOps @NonNull Set<Operation> customOps) {
        OperationRegistry operationRegistry = new OperationRegistry();
        MainnetEVMs.registerLondonOperations((OperationRegistry)operationRegistry, (GasCalculator)gasCalculator, (BigInteger)BigInteger.ZERO);
        customOperations.forEach(arg_0 -> ((OperationRegistry)operationRegistry).put(arg_0));
        customOps.forEach(arg_0 -> ((OperationRegistry)operationRegistry).put(arg_0));
        return new EVM(operationRegistry, gasCalculator, evmConfiguration, EvmSpecVersion.PARIS);
    }

    @Provides
    @Singleton
    @ServicesV034
    public static PrecompileContractRegistry providePrecompileContractRegistry(@NonNull GasCalculator gasCalculator) {
        PrecompileContractRegistry precompileContractRegistry = new PrecompileContractRegistry();
        MainnetPrecompiledContracts.populateForIstanbul((PrecompileContractRegistry)precompileContractRegistry, (GasCalculator)gasCalculator);
        return precompileContractRegistry;
    }

    @Binds
    @ServicesV034
    public FeatureFlags bindFeatureFlags(Version034FeatureFlags var1);

    @Binds
    @ServicesV034
    public AddressChecks bindAddressChecks(Version030AddressChecks var1);

    @Provides
    @IntoSet
    @ServicesV034
    public static Operation provideBalanceOperation(@NonNull GasCalculator gasCalculator, @ServicesV034 @NonNull AddressChecks addressChecks, @ServicesV034 @NonNull FeatureFlags featureFlags) {
        return new CustomBalanceOperation(gasCalculator, addressChecks, featureFlags);
    }

    @Provides
    @IntoSet
    @ServicesV034
    public static Operation provideDelegateCallOperation(@NonNull GasCalculator gasCalculator, @ServicesV034 @NonNull AddressChecks addressChecks, @ServicesV034 @NonNull FeatureFlags featureFlags) {
        return new CustomDelegateCallOperation(gasCalculator, addressChecks, featureFlags);
    }

    @Provides
    @IntoSet
    @ServicesV034
    public static Operation provideCallCodeOperation(@NonNull GasCalculator gasCalculator, @ServicesV034 @NonNull AddressChecks addressChecks, @ServicesV034 @NonNull FeatureFlags featureFlags) {
        return new CustomCallCodeOperation(gasCalculator, addressChecks, featureFlags);
    }

    @Provides
    @IntoSet
    @ServicesV034
    public static Operation provideStaticCallOperation(@NonNull GasCalculator gasCalculator, @ServicesV034 @NonNull AddressChecks addressChecks, @ServicesV034 @NonNull FeatureFlags featureFlags) {
        return new CustomStaticCallOperation(gasCalculator, addressChecks, featureFlags);
    }

    @Provides
    @IntoSet
    @ServicesV034
    public static Operation provideCallOperation(@NonNull GasCalculator gasCalculator, @ServicesV034 @NonNull FeatureFlags featureFlags, @ServicesV034 @NonNull AddressChecks addressChecks) {
        return new CustomCallOperation(featureFlags, gasCalculator, addressChecks);
    }

    @Provides
    @IntoSet
    @ServicesV034
    public static Operation provideChainIdOperation(@NonNull GasCalculator gasCalculator) {
        return new CustomChainIdOperation(gasCalculator);
    }

    @Provides
    @IntoSet
    @ServicesV034
    public static Operation provideCreateOperation(@NonNull GasCalculator gasCalculator, @NonNull CodeFactory codeFactory) {
        return new CustomCreateOperation(gasCalculator, codeFactory);
    }

    @Provides
    @IntoSet
    @ServicesV034
    public static Operation provideCreate2Operation(@NonNull GasCalculator gasCalculator, @ServicesV034 @NonNull FeatureFlags featureFlags, @NonNull CodeFactory codeFactory) {
        return new CustomCreate2Operation(gasCalculator, featureFlags, codeFactory);
    }

    @Provides
    @Singleton
    @IntoSet
    @ServicesV034
    public static Operation provideLog0Operation(@NonNull GasCalculator gasCalculator) {
        return new CustomLogOperation(0, gasCalculator);
    }

    @Provides
    @Singleton
    @IntoSet
    @ServicesV034
    public static Operation provideLog1Operation(GasCalculator gasCalculator) {
        return new CustomLogOperation(1, gasCalculator);
    }

    @Provides
    @Singleton
    @IntoSet
    @ServicesV034
    public static Operation provideLog2Operation(GasCalculator gasCalculator) {
        return new CustomLogOperation(2, gasCalculator);
    }

    @Provides
    @Singleton
    @IntoSet
    @ServicesV034
    public static Operation provideLog3Operation(GasCalculator gasCalculator) {
        return new CustomLogOperation(3, gasCalculator);
    }

    @Provides
    @Singleton
    @IntoSet
    @ServicesV034
    public static Operation provideLog4Operation(GasCalculator gasCalculator) {
        return new CustomLogOperation(4, gasCalculator);
    }

    @Provides
    @Singleton
    @IntoSet
    @ServicesV034
    public static Operation provideExtCodeHashOperation(@NonNull GasCalculator gasCalculator, @ServicesV034 @NonNull AddressChecks addressChecks, @ServicesV034 @NonNull FeatureFlags featureFlags) {
        return new CustomExtCodeHashOperation(gasCalculator, addressChecks, featureFlags);
    }

    @Provides
    @Singleton
    @IntoSet
    @ServicesV034
    public static Operation provideExtCodeSizeOperation(@NonNull GasCalculator gasCalculator, @ServicesV034 @NonNull AddressChecks addressChecks, @ServicesV034 @NonNull FeatureFlags featureFlags) {
        return new CustomExtCodeSizeOperation(gasCalculator, addressChecks, featureFlags);
    }

    @Provides
    @Singleton
    @IntoSet
    @ServicesV034
    public static Operation provideExtCodeCopyOperation(@NonNull GasCalculator gasCalculator, @ServicesV034 @NonNull AddressChecks addressChecks, @ServicesV034 @NonNull FeatureFlags featureFlags) {
        return new CustomExtCodeCopyOperation(gasCalculator, addressChecks, featureFlags);
    }

    @Provides
    @Singleton
    @IntoSet
    @ServicesV034
    public static Operation providePrevRandaoOperation(@NonNull GasCalculator gasCalculator) {
        return new CustomPrevRandaoOperation(gasCalculator);
    }

    @Provides
    @Singleton
    @IntoSet
    @ServicesV034
    public static Operation provideSelfDestructOperation(@NonNull GasCalculator gasCalculator, @ServicesV034 @NonNull AddressChecks addressChecks) {
        return new CustomSelfDestructOperation(gasCalculator, addressChecks, CustomSelfDestructOperation.UseEIP6780Semantics.NO);
    }

    @Provides
    @IntoSet
    @ServicesV034
    public static Operation provideSLoadOperation(@NonNull GasCalculator gasCalculator, @ServicesV034 @NonNull FeatureFlags featureFlags) {
        return new CustomSLoadOperation(featureFlags, new SLoadOperation(gasCalculator));
    }

    @Provides
    @IntoSet
    @ServicesV034
    public static Operation provideSStoreOperation(@NonNull GasCalculator gasCalculator, @ServicesV034 @NonNull FeatureFlags featureFlags) {
        return new CustomSStoreOperation(featureFlags, new SStoreOperation(gasCalculator, 0L));
    }
}

