/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.hevm;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.contract.ContractCreateTransactionBody;
import com.hedera.hapi.node.hooks.HookDispatchTransactionBody;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.spi.workflows.HandleException;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Wei;

public record HederaEvmTransaction(@NonNull AccountID senderId, @Nullable AccountID relayerId, @Nullable ContractID contractId, long nonce, @NonNull com.hedera.pbj.runtime.io.buffer.Bytes payload, @Nullable com.hedera.pbj.runtime.io.buffer.Bytes chainId, long value, long gasLimit, long offeredGasPrice, long maxGasAllowance, @Nullable ContractCreateTransactionBody hapiCreation, @Nullable HandleException exception, @Nullable HookDispatchTransactionBody hookDispatch) {
    public static final long NOT_APPLICABLE = -1L;

    public boolean hasExpectedNonce() {
        return this.nonce != -1L;
    }

    public boolean hasOfferedGasPrice() {
        return this.offeredGasPrice != -1L;
    }

    public boolean hasMaxGasAllowance() {
        return this.maxGasAllowance != -1L;
    }

    public boolean isCreate() {
        return this.contractId == null;
    }

    public boolean needsInitcodeExternalizedOnFailure() {
        return this.hapiCreation != null && !this.hapiCreation.hasInitcode();
    }

    public boolean isEthereumTransaction() {
        return this.relayerId != null;
    }

    public boolean isContractCall() {
        return !this.isEthereumTransaction() && !this.isCreate();
    }

    public boolean isException() {
        return this.exception != null;
    }

    public boolean permitsMissingContract() {
        return this.isEthereumTransaction() && this.hasValue();
    }

    @NonNull
    public ContractID contractIdOrThrow() {
        return Objects.requireNonNull(this.contractId);
    }

    public boolean hasValue() {
        return this.value > 0L;
    }

    public Bytes evmPayload() {
        return ConversionUtils.pbjToTuweniBytes(this.payload);
    }

    public Wei weiValue() {
        return Wei.of((long)this.value);
    }

    public long gasAvailable(long intrinsicGas) {
        return this.gasLimit - intrinsicGas;
    }

    public long upfrontCostGiven(long gasPrice) {
        long gasCost = this.gasCostGiven(gasPrice);
        return gasCost == Long.MAX_VALUE ? Long.MAX_VALUE : gasCost + this.value;
    }

    public long unusedGas(long gasUsed) {
        return this.gasLimit - gasUsed;
    }

    public long gasCostGiven(long gasPrice) {
        try {
            return Math.multiplyExact(this.gasLimit, gasPrice);
        }
        catch (ArithmeticException ignore) {
            return Long.MAX_VALUE;
        }
    }

    public long offeredGasCost() {
        try {
            return Math.multiplyExact(this.gasLimit, this.offeredGasPrice);
        }
        catch (ArithmeticException ignore) {
            return Long.MAX_VALUE;
        }
    }

    public boolean requiresFullRelayerAllowance() {
        return this.offeredGasPrice == 0L;
    }

    public HederaEvmTransaction withException(@NonNull HandleException exception) {
        return new HederaEvmTransaction(this.senderId, this.relayerId, this.contractId, this.nonce, this.payload, this.chainId, this.value, this.gasLimit, this.offeredGasPrice, this.maxGasAllowance, this.hapiCreation, exception, this.hookDispatch);
    }

    public boolean isHookDispatch() {
        return this.hookDispatch != null;
    }
}

