/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.state;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.state.contract.Bytecode;
import com.hedera.hapi.node.state.contract.SlotKey;
import com.hedera.hapi.node.state.contract.SlotValue;
import com.hedera.hapi.node.state.schedule.Schedule;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.service.contract.impl.exec.failure.CustomExceptionalHaltReason;
import com.hedera.node.app.service.contract.impl.exec.scope.ActiveContractVerificationStrategy;
import com.hedera.node.app.service.contract.impl.exec.scope.HederaNativeOperations;
import com.hedera.node.app.service.contract.impl.state.AbstractProxyEvmAccount;
import com.hedera.node.app.service.contract.impl.state.ContractStateStore;
import com.hedera.node.app.service.contract.impl.state.EvmFrameState;
import com.hedera.node.app.service.contract.impl.state.ProxyEvmAccount;
import com.hedera.node.app.service.contract.impl.state.ProxyEvmContract;
import com.hedera.node.app.service.contract.impl.state.RentFactors;
import com.hedera.node.app.service.contract.impl.state.ScheduleEvmAccount;
import com.hedera.node.app.service.contract.impl.state.StorageAccess;
import com.hedera.node.app.service.contract.impl.state.StorageAccesses;
import com.hedera.node.app.service.contract.impl.state.TokenEvmAccount;
import com.hedera.node.app.service.contract.impl.state.TxStorageUsage;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.service.contract.impl.utils.RedirectBytecodeUtils;
import com.hedera.node.app.service.token.AliasUtils;
import com.hedera.node.app.spi.ids.EntityIdFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.account.MutableAccount;
import org.hyperledger.besu.evm.code.CodeFactory;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;

public class DispatchingEvmFrameState
implements EvmFrameState {
    public static final Key HOLLOW_ACCOUNT_KEY = Key.newBuilder().keyList(KeyList.DEFAULT).build();
    private final HederaNativeOperations nativeOperations;
    private final ContractStateStore contractStateStore;
    private final CodeFactory codeFactory;

    public DispatchingEvmFrameState(@NonNull HederaNativeOperations nativeOperations, @NonNull ContractStateStore contractStateStore, @NonNull CodeFactory codeFactory) {
        this.nativeOperations = Objects.requireNonNull(nativeOperations);
        this.contractStateStore = Objects.requireNonNull(contractStateStore);
        this.codeFactory = codeFactory;
    }

    @Override
    public void setStorageValue(@NonNull ContractID contractID, @NonNull UInt256 key, @NonNull UInt256 value) {
        SlotKey slotKey = new SlotKey(contractID, ConversionUtils.tuweniToPbjBytes((Bytes)Objects.requireNonNull(key)));
        SlotValue oldSlotValue = this.contractStateStore.getSlotValue(slotKey);
        if (oldSlotValue == null && value.isZero()) {
            return;
        }
        SlotValue slotValue = new SlotValue(ConversionUtils.tuweniToPbjBytes((Bytes)Objects.requireNonNull(value)), oldSlotValue == null ? com.hedera.pbj.runtime.io.buffer.Bytes.EMPTY : oldSlotValue.previousKey(), oldSlotValue == null ? com.hedera.pbj.runtime.io.buffer.Bytes.EMPTY : oldSlotValue.nextKey());
        this.contractStateStore.putSlot(slotKey, slotValue);
    }

    @Override
    @NonNull
    public UInt256 getStorageValue(ContractID contractID, @NonNull UInt256 key) {
        SlotKey slotKey = new SlotKey(contractID, ConversionUtils.tuweniToPbjBytes((Bytes)Objects.requireNonNull(key)));
        return this.valueOrZero(this.contractStateStore.getSlotValue(slotKey));
    }

    @Override
    @NonNull
    public UInt256 getOriginalStorageValue(ContractID contractID, @NonNull UInt256 key) {
        SlotKey slotKey = new SlotKey(contractID, ConversionUtils.tuweniToPbjBytes((Bytes)Objects.requireNonNull(key)));
        return this.valueOrZero(this.contractStateStore.getOriginalSlotValue(slotKey));
    }

    @Override
    @NonNull
    public TxStorageUsage getTxStorageUsage(boolean includeChangedKeys) {
        TreeMap<ContractID, List> modifications = new TreeMap<ContractID, List>(HapiUtils.CONTRACT_ID_COMPARATOR);
        HashSet<SlotKey> changedKeys = includeChangedKeys ? new HashSet<SlotKey>() : null;
        this.contractStateStore.getModifiedSlotKeys().forEach(slotKey -> {
            StorageAccess access = StorageAccess.newWrite(ConversionUtils.pbjToTuweniUInt256(slotKey.key()), this.valueOrZero(this.contractStateStore.getOriginalSlotValue((SlotKey)slotKey)), this.valueOrZero(this.contractStateStore.getSlotValue((SlotKey)slotKey)));
            modifications.computeIfAbsent(slotKey.contractID(), k -> new ArrayList()).add(access);
            if (includeChangedKeys && access.isLogicalChange()) {
                changedKeys.add((SlotKey)slotKey);
            }
        });
        ArrayList<StorageAccesses> allChanges = new ArrayList<StorageAccesses>();
        modifications.forEach((number, storageAccesses) -> allChanges.add(new StorageAccesses((ContractID)number, (List<StorageAccess>)storageAccesses)));
        return new TxStorageUsage(allChanges, changedKeys);
    }

    @Override
    public long getKvStateSize() {
        return this.contractStateStore.getNumSlots();
    }

    @Override
    @NonNull
    public RentFactors getRentFactorsFor(ContractID contractID) {
        Account account = this.validatedAccount(contractID);
        return new RentFactors(account.contractKvPairsNumber(), account.expirationSecond());
    }

    @Override
    @NonNull
    public EntityIdFactory entityIdFactory() {
        return this.nativeOperations.entityIdFactory();
    }

    @Override
    @NonNull
    public Bytes getCode(@NonNull ContractID contractID) {
        Objects.requireNonNull(contractID);
        Bytecode numberedBytecode = this.contractStateStore.getBytecode(contractID);
        if (numberedBytecode == null) {
            return Bytes.EMPTY;
        }
        com.hedera.pbj.runtime.io.buffer.Bytes code = numberedBytecode.code();
        return ConversionUtils.pbjToTuweniBytes(code);
    }

    @Override
    @NonNull
    public Hash getCodeHash(@NonNull ContractID contractID, @NonNull CodeFactory codeFactory) {
        Objects.requireNonNull(contractID);
        Bytecode numberedBytecode = this.contractStateStore.getBytecode(contractID);
        if (numberedBytecode == null) {
            return Hash.EMPTY;
        }
        return codeFactory.createCode(ConversionUtils.pbjToTuweniBytes(numberedBytecode.code()), false).getCodeHash();
    }

    @Override
    @NonNull
    public Bytes getTokenRedirectCode(@NonNull Address address) {
        return RedirectBytecodeUtils.tokenProxyBytecodeFor(address);
    }

    @Override
    @NonNull
    public Hash getTokenRedirectCodeHash(@NonNull Address address) {
        return this.codeFactory.createCode(RedirectBytecodeUtils.tokenProxyBytecodeFor(address), false).getCodeHash();
    }

    @Override
    @NonNull
    public Bytes getAccountRedirectCode(@Nullable Address address) {
        return RedirectBytecodeUtils.accountProxyBytecodeFor(address);
    }

    @Override
    @NonNull
    public Hash getAccountRedirectCodeHash(@Nullable Address address) {
        return this.codeFactory.createCode(RedirectBytecodeUtils.accountProxyBytecodeFor(address), false).getCodeHash();
    }

    @Override
    @NonNull
    public Bytes getScheduleRedirectCode(@Nullable Address address) {
        return RedirectBytecodeUtils.scheduleProxyBytecodeFor(address);
    }

    @Override
    @NonNull
    public Hash getScheduleRedirectCodeHash(@Nullable Address address) {
        return this.codeFactory.createCode(RedirectBytecodeUtils.scheduleProxyBytecodeFor(address), false).getCodeHash();
    }

    @Override
    public long getNonce(AccountID accountID) {
        return this.validatedAccount(accountID).ethereumNonce();
    }

    @Override
    public Account getNativeAccount(AccountID accountID) {
        return this.validatedAccount(accountID);
    }

    @Override
    public int getNumTreasuryTitles(AccountID accountID) {
        return this.validatedAccount(accountID).numberTreasuryTitles();
    }

    @Override
    public boolean isContract(AccountID accountID) {
        return this.validatedAccount(accountID).smartContract();
    }

    @Override
    public int getNumPositiveTokenBalances(AccountID accountID) {
        return this.validatedAccount(accountID).numberPositiveBalances();
    }

    @Override
    public void setCode(ContractID contractID, @NonNull Bytes code) {
        this.contractStateStore.putBytecode(contractID, new Bytecode(ConversionUtils.tuweniToPbjBytes(Objects.requireNonNull(code))));
    }

    @Override
    public void setNonce(long number, long nonce) {
        this.nativeOperations.setNonce(number, nonce);
    }

    @Override
    public Wei getBalance(AccountID accountID) {
        return Wei.of((long)this.validatedAccount(accountID).tinybarBalance());
    }

    @Override
    public long getIdNumber(@NonNull Address address) {
        long number = ConversionUtils.maybeMissingNumberOf(address, this.nativeOperations);
        if (number == -1L) {
            throw new IllegalArgumentException("Address " + String.valueOf(address) + " has no associated Hedera id");
        }
        return number;
    }

    @Override
    @Nullable
    public Address getAddress(long number) {
        AccountID accountID = this.entityIdFactory().newAccountId(number);
        Account account = this.nativeOperations.getAccount(accountID);
        if (account != null) {
            if (account.deleted()) {
                return null;
            }
            com.hedera.pbj.runtime.io.buffer.Bytes evmAddress = AliasUtils.extractEvmAddress((com.hedera.pbj.runtime.io.buffer.Bytes)account.alias());
            return evmAddress == null ? ConversionUtils.asLongZeroAddress(number) : ConversionUtils.pbjToBesuAddress(evmAddress);
        }
        Token token = this.nativeOperations.getToken(this.entityIdFactory().newTokenId(number));
        Schedule schedule = this.nativeOperations.getSchedule(this.entityIdFactory().newScheduleId(number));
        if (token != null || schedule != null) {
            return ConversionUtils.asLongZeroAddress(number);
        }
        throw new IllegalArgumentException("No account, token or schedule has number " + number);
    }

    @Override
    @Nullable
    public Address getAddress(AccountID accountID) {
        Account account = this.nativeOperations.getAccount(accountID);
        if (account == null) {
            throw new IllegalArgumentException("No account has id " + String.valueOf(accountID));
        }
        if (account.deleted()) {
            return null;
        }
        com.hedera.pbj.runtime.io.buffer.Bytes evmAddress = AliasUtils.extractEvmAddress((com.hedera.pbj.runtime.io.buffer.Bytes)account.alias());
        return evmAddress == null ? ConversionUtils.asLongZeroAddress(accountID) : ConversionUtils.pbjToBesuAddress(evmAddress);
    }

    @Override
    public boolean isHollowAccount(@NonNull Address address) {
        long number = ConversionUtils.maybeMissingNumberOf(address, this.nativeOperations);
        if (number == -1L) {
            return false;
        }
        AccountID accountID = AccountID.newBuilder().accountNum(number).build();
        Account account = this.nativeOperations.getAccount(accountID);
        if (account == null) {
            return false;
        }
        return HOLLOW_ACCOUNT_KEY.equals((Object)account.key());
    }

    @Override
    public void finalizeHollowAccount(@NonNull Address address) {
        this.nativeOperations.finalizeHollowAccountAsContract(ConversionUtils.tuweniToPbjBytes((Bytes)address));
    }

    @Override
    public long numBytecodesInState() {
        return this.contractStateStore.getNumBytecodes();
    }

    @Override
    public Optional<ExceptionalHaltReason> tryTransfer(@NonNull Address sendingContract, @NonNull Address recipient, long amount, boolean delegateCall) {
        AbstractProxyEvmAccount from = (AbstractProxyEvmAccount)this.getAccount(sendingContract);
        if (from == null) {
            return Optional.of(CustomExceptionalHaltReason.INVALID_SOLIDITY_ADDRESS);
        }
        org.hyperledger.besu.evm.account.Account to = this.getAccount(recipient);
        if (to == null) {
            return Optional.of(CustomExceptionalHaltReason.INVALID_SOLIDITY_ADDRESS);
        }
        if (to instanceof TokenEvmAccount || to instanceof ScheduleEvmAccount) {
            return Optional.of(ExceptionalHaltReason.ILLEGAL_STATE_CHANGE);
        }
        ResponseCodeEnum status = this.nativeOperations.transferWithReceiverSigCheck(amount, from.hederaId(), ((AbstractProxyEvmAccount)to).hederaId(), new ActiveContractVerificationStrategy(from.hederaContractId(), ConversionUtils.tuweniToPbjBytes((Bytes)from.getAddress()), delegateCall, ActiveContractVerificationStrategy.UseTopLevelSigs.YES));
        if (status != ResponseCodeEnum.OK) {
            if (status == ResponseCodeEnum.INVALID_SIGNATURE) {
                return Optional.of(CustomExceptionalHaltReason.INVALID_SIGNATURE);
            }
            throw new IllegalStateException("Transfer from 0.0." + String.valueOf(from.accountID) + " to 0.0." + String.valueOf(((AbstractProxyEvmAccount)to).accountID) + " failed with status " + String.valueOf(status) + " despite valid preconditions");
        }
        return Optional.empty();
    }

    @Override
    public Optional<ExceptionalHaltReason> tryLazyCreation(@NonNull Address address) {
        AccountID accountID;
        Account account;
        if (ConversionUtils.isLongZero(address)) {
            return Optional.of(CustomExceptionalHaltReason.INVALID_ALIAS_KEY);
        }
        long number = ConversionUtils.maybeMissingNumberOf(address, this.nativeOperations);
        if (number != -1L && (account = this.nativeOperations.getAccount(accountID = AccountID.newBuilder().accountNum(number).build())) != null) {
            if (account.expiredAndPendingRemoval()) {
                return Optional.of(CustomExceptionalHaltReason.FAILURE_DURING_LAZY_ACCOUNT_CREATION);
            }
            throw new IllegalArgumentException("Unexpired account 0.0." + number + " already exists at address " + String.valueOf(address));
        }
        ResponseCodeEnum status = this.nativeOperations.createHollowAccount(ConversionUtils.tuweniToPbjBytes((Bytes)address));
        if (status != ResponseCodeEnum.SUCCESS) {
            return status == ResponseCodeEnum.MAX_CHILD_RECORDS_EXCEEDED ? Optional.of(CustomExceptionalHaltReason.INSUFFICIENT_CHILD_RECORDS) : Optional.of(CustomExceptionalHaltReason.FAILURE_DURING_LAZY_ACCOUNT_CREATION);
        }
        return Optional.empty();
    }

    @Override
    public Optional<ExceptionalHaltReason> tryTrackingSelfDestructBeneficiary(@NonNull Address deleted, @NonNull Address beneficiary, @NonNull MessageFrame frame) {
        Objects.requireNonNull(deleted);
        Objects.requireNonNull(beneficiary);
        Objects.requireNonNull(frame);
        if (deleted.equals((Object)beneficiary)) {
            return Optional.of(CustomExceptionalHaltReason.SELF_DESTRUCT_TO_SELF);
        }
        org.hyperledger.besu.evm.account.Account beneficiaryAccount = this.getAccount(beneficiary);
        if (beneficiaryAccount == null || beneficiaryAccount instanceof TokenEvmAccount || beneficiaryAccount instanceof ScheduleEvmAccount) {
            return Optional.of(CustomExceptionalHaltReason.INVALID_SOLIDITY_ADDRESS);
        }
        AbstractProxyEvmAccount deletedAccount = (AbstractProxyEvmAccount)Objects.requireNonNull(this.getAccount(deleted));
        if (deletedAccount.numTreasuryTitles() > 0) {
            return Optional.of(CustomExceptionalHaltReason.CONTRACT_IS_TREASURY);
        }
        if (deletedAccount.numPositiveTokenBalances() > 0) {
            return Optional.of(CustomExceptionalHaltReason.CONTRACT_STILL_OWNS_NFTS);
        }
        this.nativeOperations.trackSelfDestructBeneficiary(deletedAccount.hederaId(), ((AbstractProxyEvmAccount)beneficiaryAccount).hederaId(), frame);
        return Optional.empty();
    }

    @Override
    public void trackSelfDestructBeneficiary(@NonNull Address deleted, @NonNull Address beneficiary, @NonNull MessageFrame frame) {
        Objects.requireNonNull(deleted);
        Objects.requireNonNull(beneficiary);
        org.hyperledger.besu.evm.account.Account beneficiaryAccount = this.getAccount(beneficiary);
        AbstractProxyEvmAccount deletedAccount = (AbstractProxyEvmAccount)Objects.requireNonNull(this.getAccount(deleted));
        this.nativeOperations.trackSelfDestructBeneficiary(deletedAccount.hederaId(), ((AbstractProxyEvmAccount)beneficiaryAccount).hederaId(), frame);
    }

    @Override
    @Nullable
    public org.hyperledger.besu.evm.account.Account getAccount(@NonNull Address address) {
        return this.getMutableAccount(address);
    }

    @Override
    @Nullable
    public MutableAccount getMutableAccount(@NonNull Address address) {
        long number = ConversionUtils.maybeMissingNumberOf(address, this.nativeOperations);
        if (number == -1L) {
            return null;
        }
        AccountID accountID = this.entityIdFactory().newAccountId(number);
        Account account = this.nativeOperations.getAccount(accountID);
        if (account != null) {
            if (account.deleted() || account.expiredAndPendingRemoval() || this.isNotPriority(address, account)) {
                return null;
            }
            if (account.smartContract()) {
                return new ProxyEvmContract(account.accountId(), this, this.codeFactory);
            }
            return new ProxyEvmAccount(account.accountId(), this);
        }
        Token token = this.nativeOperations.getToken(this.entityIdFactory().newTokenId(number));
        if (token != null) {
            return new TokenEvmAccount(address, this);
        }
        Schedule schedule = this.nativeOperations.getSchedule(this.nativeOperations.entityIdFactory().newScheduleId(number));
        if (schedule != null) {
            return new ScheduleEvmAccount(address, this);
        }
        return null;
    }

    private boolean isNotPriority(Address address, @NonNull Account account) {
        Objects.requireNonNull(account);
        com.hedera.pbj.runtime.io.buffer.Bytes maybeEvmAddress = AliasUtils.extractEvmAddress((com.hedera.pbj.runtime.io.buffer.Bytes)account.alias());
        return maybeEvmAddress != null && !address.equals((Object)ConversionUtils.pbjToBesuAddress(maybeEvmAddress));
    }

    private Account validatedAccount(AccountID accountID) {
        Account account = this.nativeOperations.getAccount(accountID);
        if (account == null) {
            throw new IllegalArgumentException("No account has id " + String.valueOf(accountID));
        }
        return account;
    }

    private Account validatedAccount(ContractID contractID) {
        Account account = this.nativeOperations.getAccount(contractID);
        if (account == null) {
            throw new IllegalArgumentException("No account found for contract ID " + String.valueOf(contractID));
        }
        return account;
    }

    private UInt256 valueOrZero(@Nullable SlotValue slotValue) {
        return slotValue == null ? UInt256.ZERO : ConversionUtils.pbjToTuweniUInt256(slotValue.value());
    }
}

