/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.state;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.node.app.service.contract.impl.state.AbstractProxyEvmAccount;
import com.hedera.node.app.service.contract.impl.state.EvmFrameState;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.code.CodeFactory;

public class ProxyEvmContract
extends AbstractProxyEvmAccount {
    private final CodeFactory codeFactory;

    public ProxyEvmContract(AccountID accountID, @NonNull EvmFrameState state, @NonNull CodeFactory codeFactory) {
        super(accountID, state);
        this.codeFactory = codeFactory;
    }

    @Override
    @NonNull
    public Code getEvmCode(@NonNull Bytes functionSelector, @NonNull CodeFactory codeFactory) {
        return codeFactory.createCode(this.getCode(), false);
    }

    @NonNull
    public Bytes getCode() {
        return this.state.getCode(this.hederaContractId());
    }

    @NonNull
    public Hash getCodeHash() {
        return this.state.getCodeHash(this.hederaContractId(), this.codeFactory);
    }
}

